/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Host;
import software.amazon.awssdk.services.ec2.model.HostInstance;
import software.amazon.awssdk.services.ec2.transform.AvailableCapacityUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.HostInstanceUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.HostPropertiesUnmarshaller;

public class HostUnmarshaller
implements Unmarshaller<Host, StaxUnmarshallerContext> {
    private static final HostUnmarshaller INSTANCE = new HostUnmarshaller();

    public Host unmarshall(StaxUnmarshallerContext context) throws Exception {
        Host.Builder host;
        block13: {
            host = Host.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<HostInstance> instances = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    host.instances(instances);
                    break block13;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("autoPlacement", targetDepth)) {
                        host.autoPlacement(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("availabilityZone", targetDepth)) {
                        host.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("availableCapacity", targetDepth)) {
                        host.availableCapacity(AvailableCapacityUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("clientToken", targetDepth)) {
                        host.clientToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("hostId", targetDepth)) {
                        host.hostId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("hostProperties", targetDepth)) {
                        host.hostProperties(HostPropertiesUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("hostReservationId", targetDepth)) {
                        host.hostReservationId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instances", targetDepth)) {
                        instances = new ArrayList<HostInstance>();
                        continue;
                    }
                    if (context.testExpression("instances/item", targetDepth)) {
                        instances.add(HostInstanceUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("state", targetDepth)) continue;
                    host.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            host.instances(instances);
        }
        return (Host)host.build();
    }

    public static HostUnmarshaller getInstance() {
        return INSTANCE;
    }
}

