/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeInstancesRequestMarshaller
implements Marshaller<Request<DescribeInstancesRequest>, DescribeInstancesRequest> {
    public Request<DescribeInstancesRequest> marshall(DescribeInstancesRequest describeInstancesRequest) {
        List<String> describeInstancesRequestInstanceIdsList;
        if (describeInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstancesRequest, "EC2Client");
        request.addParameter("Action", "DescribeInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeInstancesRequestFiltersList = describeInstancesRequest.filters();
        if (describeInstancesRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeInstancesRequestFiltersListValue : describeInstancesRequestFiltersList) {
                List<String> filterValuesList;
                if (describeInstancesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeInstancesRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeInstancesRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((describeInstancesRequestInstanceIdsList = describeInstancesRequest.instanceIds()) != null) {
            int instanceIdsListIndex = 1;
            for (String describeInstancesRequestInstanceIdsListValue : describeInstancesRequestInstanceIdsList) {
                if (describeInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)describeInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (describeInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeInstancesRequest.maxResults()));
        }
        if (describeInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeInstancesRequest.nextToken()));
        }
        return request;
    }
}

