/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest;

public class CopyFpgaImageRequestMarshaller
implements Marshaller<Request<CopyFpgaImageRequest>, CopyFpgaImageRequest> {
    public Request<CopyFpgaImageRequest> marshall(CopyFpgaImageRequest copyFpgaImageRequest) {
        if (copyFpgaImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyFpgaImageRequest, "EC2Client");
        request.addParameter("Action", "CopyFpgaImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyFpgaImageRequest.sourceFpgaImageId() != null) {
            request.addParameter("SourceFpgaImageId", StringUtils.fromString((String)copyFpgaImageRequest.sourceFpgaImageId()));
        }
        if (copyFpgaImageRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)copyFpgaImageRequest.description()));
        }
        if (copyFpgaImageRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)copyFpgaImageRequest.name()));
        }
        if (copyFpgaImageRequest.sourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString((String)copyFpgaImageRequest.sourceRegion()));
        }
        if (copyFpgaImageRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)copyFpgaImageRequest.clientToken()));
        }
        return request;
    }
}

