/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse;
import software.amazon.awssdk.services.ec2.model.VolumeStatusItem;

public final class DescribeVolumeStatusPaginator
implements SdkIterable<DescribeVolumeStatusResponse> {
    private final EC2Client client;
    private final DescribeVolumeStatusRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeVolumeStatusPaginator(EC2Client client, DescribeVolumeStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVolumeStatusResponseFetcher();
    }

    public Iterator<DescribeVolumeStatusResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<VolumeStatusItem> volumeStatuses() {
        Function<DescribeVolumeStatusResponse, Iterator> getIterator = response -> response != null ? response.volumeStatuses().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeVolumeStatusResponseFetcher
    implements NextPageFetcher<DescribeVolumeStatusResponse> {
        private DescribeVolumeStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumeStatusResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeVolumeStatusResponse nextPage(DescribeVolumeStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumeStatusPaginator.this.client.describeVolumeStatus(DescribeVolumeStatusPaginator.this.firstRequest);
            }
            return DescribeVolumeStatusPaginator.this.client.describeVolumeStatus((DescribeVolumeStatusRequest)((Object)DescribeVolumeStatusPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

