/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpPermissionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RevokeSecurityGroupEgressRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RevokeSecurityGroupEgressRequest> {
    private final String groupId;
    private final List<IpPermission> ipPermissions;
    private final String cidrIp;
    private final Integer fromPort;
    private final String ipProtocol;
    private final Integer toPort;
    private final String sourceSecurityGroupName;
    private final String sourceSecurityGroupOwnerId;

    private RevokeSecurityGroupEgressRequest(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.ipPermissions = builder.ipPermissions;
        this.cidrIp = builder.cidrIp;
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.toPort = builder.toPort;
        this.sourceSecurityGroupName = builder.sourceSecurityGroupName;
        this.sourceSecurityGroupOwnerId = builder.sourceSecurityGroupOwnerId;
    }

    public String groupId() {
        return this.groupId;
    }

    public List<IpPermission> ipPermissions() {
        return this.ipPermissions;
    }

    public String cidrIp() {
        return this.cidrIp;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public String ipProtocol() {
        return this.ipProtocol;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public String sourceSecurityGroupName() {
        return this.sourceSecurityGroupName;
    }

    public String sourceSecurityGroupOwnerId() {
        return this.sourceSecurityGroupOwnerId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSecurityGroupOwnerId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeSecurityGroupEgressRequest)) {
            return false;
        }
        RevokeSecurityGroupEgressRequest other = (RevokeSecurityGroupEgressRequest)((Object)obj);
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.ipPermissions(), other.ipPermissions()) && Objects.equals(this.cidrIp(), other.cidrIp()) && Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.ipProtocol(), other.ipProtocol()) && Objects.equals(this.toPort(), other.toPort()) && Objects.equals(this.sourceSecurityGroupName(), other.sourceSecurityGroupName()) && Objects.equals(this.sourceSecurityGroupOwnerId(), other.sourceSecurityGroupOwnerId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.groupId() != null) {
            sb.append("GroupId: ").append(this.groupId()).append(",");
        }
        if (this.ipPermissions() != null) {
            sb.append("IpPermissions: ").append(this.ipPermissions()).append(",");
        }
        if (this.cidrIp() != null) {
            sb.append("CidrIp: ").append(this.cidrIp()).append(",");
        }
        if (this.fromPort() != null) {
            sb.append("FromPort: ").append(this.fromPort()).append(",");
        }
        if (this.ipProtocol() != null) {
            sb.append("IpProtocol: ").append(this.ipProtocol()).append(",");
        }
        if (this.toPort() != null) {
            sb.append("ToPort: ").append(this.toPort()).append(",");
        }
        if (this.sourceSecurityGroupName() != null) {
            sb.append("SourceSecurityGroupName: ").append(this.sourceSecurityGroupName()).append(",");
        }
        if (this.sourceSecurityGroupOwnerId() != null) {
            sb.append("SourceSecurityGroupOwnerId: ").append(this.sourceSecurityGroupOwnerId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "IpPermissions": {
                return Optional.of(clazz.cast(this.ipPermissions()));
            }
            case "CidrIp": {
                return Optional.of(clazz.cast(this.cidrIp()));
            }
            case "FromPort": {
                return Optional.of(clazz.cast(this.fromPort()));
            }
            case "IpProtocol": {
                return Optional.of(clazz.cast(this.ipProtocol()));
            }
            case "ToPort": {
                return Optional.of(clazz.cast(this.toPort()));
            }
            case "SourceSecurityGroupName": {
                return Optional.of(clazz.cast(this.sourceSecurityGroupName()));
            }
            case "SourceSecurityGroupOwnerId": {
                return Optional.of(clazz.cast(this.sourceSecurityGroupOwnerId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String groupId;
        private List<IpPermission> ipPermissions;
        private String cidrIp;
        private Integer fromPort;
        private String ipProtocol;
        private Integer toPort;
        private String sourceSecurityGroupName;
        private String sourceSecurityGroupOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeSecurityGroupEgressRequest model) {
            this.groupId(model.groupId);
            this.ipPermissions(model.ipPermissions);
            this.cidrIp(model.cidrIp);
            this.fromPort(model.fromPort);
            this.ipProtocol(model.ipProtocol);
            this.toPort(model.toPort);
            this.sourceSecurityGroupName(model.sourceSecurityGroupName);
            this.sourceSecurityGroupOwnerId(model.sourceSecurityGroupOwnerId);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final Collection<IpPermission.Builder> getIpPermissions() {
            return this.ipPermissions != null ? (Collection)this.ipPermissions.stream().map(IpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipPermissions(Collection<IpPermission> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copy(ipPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPermissions(IpPermission ... ipPermissions) {
            this.ipPermissions(Arrays.asList(ipPermissions));
            return this;
        }

        public final void setIpPermissions(Collection<IpPermission.BuilderImpl> ipPermissions) {
            this.ipPermissions = IpPermissionListCopier.copyFromBuilder(ipPermissions);
        }

        public final String getCidrIp() {
            return this.cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getSourceSecurityGroupName() {
            return this.sourceSecurityGroupName;
        }

        @Override
        public final Builder sourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
            return this;
        }

        public final void setSourceSecurityGroupName(String sourceSecurityGroupName) {
            this.sourceSecurityGroupName = sourceSecurityGroupName;
        }

        public final String getSourceSecurityGroupOwnerId() {
            return this.sourceSecurityGroupOwnerId;
        }

        @Override
        public final Builder sourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
            return this;
        }

        public final void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
            this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
        }

        public RevokeSecurityGroupEgressRequest build() {
            return new RevokeSecurityGroupEgressRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RevokeSecurityGroupEgressRequest> {
        public Builder groupId(String var1);

        public Builder ipPermissions(Collection<IpPermission> var1);

        public Builder ipPermissions(IpPermission ... var1);

        public Builder cidrIp(String var1);

        public Builder fromPort(Integer var1);

        public Builder ipProtocol(String var1);

        public Builder toPort(Integer var1);

        public Builder sourceSecurityGroupName(String var1);

        public Builder sourceSecurityGroupOwnerId(String var1);
    }
}

