/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Placement
implements ToCopyableBuilder<Builder, Placement> {
    private final String availabilityZone;
    private final String affinity;
    private final String groupName;
    private final String hostId;
    private final String tenancy;
    private final String spreadDomain;

    private Placement(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.affinity = builder.affinity;
        this.groupName = builder.groupName;
        this.hostId = builder.hostId;
        this.tenancy = builder.tenancy;
        this.spreadDomain = builder.spreadDomain;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String affinity() {
        return this.affinity;
    }

    public String groupName() {
        return this.groupName;
    }

    public String hostId() {
        return this.hostId;
    }

    public Tenancy tenancy() {
        return Tenancy.fromValue(this.tenancy);
    }

    public String tenancyString() {
        return this.tenancy;
    }

    public String spreadDomain() {
        return this.spreadDomain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.affinity());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spreadDomain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Placement)) {
            return false;
        }
        Placement other = (Placement)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.affinity(), other.affinity()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.tenancyString(), other.tenancyString()) && Objects.equals(this.spreadDomain(), other.spreadDomain());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.affinity() != null) {
            sb.append("Affinity: ").append(this.affinity()).append(",");
        }
        if (this.groupName() != null) {
            sb.append("GroupName: ").append(this.groupName()).append(",");
        }
        if (this.hostId() != null) {
            sb.append("HostId: ").append(this.hostId()).append(",");
        }
        if (this.tenancyString() != null) {
            sb.append("Tenancy: ").append(this.tenancyString()).append(",");
        }
        if (this.spreadDomain() != null) {
            sb.append("SpreadDomain: ").append(this.spreadDomain()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "Affinity": {
                return Optional.of(clazz.cast(this.affinity()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "HostId": {
                return Optional.of(clazz.cast(this.hostId()));
            }
            case "Tenancy": {
                return Optional.of(clazz.cast(this.tenancyString()));
            }
            case "SpreadDomain": {
                return Optional.of(clazz.cast(this.spreadDomain()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String affinity;
        private String groupName;
        private String hostId;
        private String tenancy;
        private String spreadDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(Placement model) {
            this.availabilityZone(model.availabilityZone);
            this.affinity(model.affinity);
            this.groupName(model.groupName);
            this.hostId(model.hostId);
            this.tenancy(model.tenancy);
            this.spreadDomain(model.spreadDomain);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAffinity() {
            return this.affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getHostId() {
            return this.hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(Tenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final String getSpreadDomain() {
            return this.spreadDomain;
        }

        @Override
        public final Builder spreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
            return this;
        }

        public final void setSpreadDomain(String spreadDomain) {
            this.spreadDomain = spreadDomain;
        }

        public Placement build() {
            return new Placement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Placement> {
        public Builder availabilityZone(String var1);

        public Builder affinity(String var1);

        public Builder groupName(String var1);

        public Builder hostId(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(Tenancy var1);

        public Builder spreadDomain(String var1);
    }
}

