/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.InterfacePermissionType;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkInterfacePermission
implements ToCopyableBuilder<Builder, NetworkInterfacePermission> {
    private final String networkInterfacePermissionId;
    private final String networkInterfaceId;
    private final String awsAccountId;
    private final String awsService;
    private final String permission;
    private final NetworkInterfacePermissionState permissionState;

    private NetworkInterfacePermission(BuilderImpl builder) {
        this.networkInterfacePermissionId = builder.networkInterfacePermissionId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.awsAccountId = builder.awsAccountId;
        this.awsService = builder.awsService;
        this.permission = builder.permission;
        this.permissionState = builder.permissionState;
    }

    public String networkInterfacePermissionId() {
        return this.networkInterfacePermissionId;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String awsService() {
        return this.awsService;
    }

    public InterfacePermissionType permission() {
        return InterfacePermissionType.fromValue(this.permission);
    }

    public String permissionString() {
        return this.permission;
    }

    public NetworkInterfacePermissionState permissionState() {
        return this.permissionState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfacePermissionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsService());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionState());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePermission)) {
            return false;
        }
        NetworkInterfacePermission other = (NetworkInterfacePermission)obj;
        return Objects.equals(this.networkInterfacePermissionId(), other.networkInterfacePermissionId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsService(), other.awsService()) && Objects.equals(this.permissionString(), other.permissionString()) && Objects.equals(this.permissionState(), other.permissionState());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.networkInterfacePermissionId() != null) {
            sb.append("NetworkInterfacePermissionId: ").append(this.networkInterfacePermissionId()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.awsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.awsAccountId()).append(",");
        }
        if (this.awsService() != null) {
            sb.append("AwsService: ").append(this.awsService()).append(",");
        }
        if (this.permissionString() != null) {
            sb.append("Permission: ").append(this.permissionString()).append(",");
        }
        if (this.permissionState() != null) {
            sb.append("PermissionState: ").append(this.permissionState()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfacePermissionId": {
                return Optional.of(clazz.cast(this.networkInterfacePermissionId()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "AwsAccountId": {
                return Optional.of(clazz.cast(this.awsAccountId()));
            }
            case "AwsService": {
                return Optional.of(clazz.cast(this.awsService()));
            }
            case "Permission": {
                return Optional.of(clazz.cast(this.permissionString()));
            }
            case "PermissionState": {
                return Optional.of(clazz.cast(this.permissionState()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInterfacePermissionId;
        private String networkInterfaceId;
        private String awsAccountId;
        private String awsService;
        private String permission;
        private NetworkInterfacePermissionState permissionState;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePermission model) {
            this.networkInterfacePermissionId(model.networkInterfacePermissionId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.awsAccountId(model.awsAccountId);
            this.awsService(model.awsService);
            this.permission(model.permission);
            this.permissionState(model.permissionState);
        }

        public final String getNetworkInterfacePermissionId() {
            return this.networkInterfacePermissionId;
        }

        @Override
        public final Builder networkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
            return this;
        }

        public final void setNetworkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getAwsService() {
            return this.awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        public final String getPermission() {
            return this.permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(InterfacePermissionType permission) {
            this.permission(permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        public final NetworkInterfacePermissionState.Builder getPermissionState() {
            return this.permissionState != null ? this.permissionState.toBuilder() : null;
        }

        @Override
        public final Builder permissionState(NetworkInterfacePermissionState permissionState) {
            this.permissionState = permissionState;
            return this;
        }

        public final void setPermissionState(NetworkInterfacePermissionState.BuilderImpl permissionState) {
            this.permissionState = permissionState != null ? permissionState.build() : null;
        }

        public NetworkInterfacePermission build() {
            return new NetworkInterfacePermission(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkInterfacePermission> {
        public Builder networkInterfacePermissionId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder awsAccountId(String var1);

        public Builder awsService(String var1);

        public Builder permission(String var1);

        public Builder permission(InterfacePermissionType var1);

        public Builder permissionState(NetworkInterfacePermissionState var1);

        default public Builder permissionState(Consumer<NetworkInterfacePermissionState.Builder> permissionState) {
            return this.permissionState((NetworkInterfacePermissionState)((NetworkInterfacePermissionState.Builder)NetworkInterfacePermissionState.builder().apply(permissionState)).build());
        }
    }
}

