/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.VpcTenancy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyVpcTenancyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyVpcTenancyRequest> {
    private final String vpcId;
    private final String instanceTenancy;

    private ModifyVpcTenancyRequest(BuilderImpl builder) {
        this.vpcId = builder.vpcId;
        this.instanceTenancy = builder.instanceTenancy;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public VpcTenancy instanceTenancy() {
        return VpcTenancy.fromValue(this.instanceTenancy);
    }

    public String instanceTenancyString() {
        return this.instanceTenancy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcTenancyRequest)) {
            return false;
        }
        ModifyVpcTenancyRequest other = (ModifyVpcTenancyRequest)((Object)obj);
        return Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.instanceTenancyString(), other.instanceTenancyString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.instanceTenancyString() != null) {
            sb.append("InstanceTenancy: ").append(this.instanceTenancyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "InstanceTenancy": {
                return Optional.of(clazz.cast(this.instanceTenancyString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcId;
        private String instanceTenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcTenancyRequest model) {
            this.vpcId(model.vpcId);
            this.instanceTenancy(model.instanceTenancy);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(VpcTenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public ModifyVpcTenancyRequest build() {
            return new ModifyVpcTenancyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyVpcTenancyRequest> {
        public Builder vpcId(String var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(VpcTenancy var1);
    }
}

