/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Affinity;
import software.amazon.awssdk.services.ec2.model.HostTenancy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyInstancePlacementRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyInstancePlacementRequest> {
    private final String affinity;
    private final String hostId;
    private final String instanceId;
    private final String tenancy;

    private ModifyInstancePlacementRequest(BuilderImpl builder) {
        this.affinity = builder.affinity;
        this.hostId = builder.hostId;
        this.instanceId = builder.instanceId;
        this.tenancy = builder.tenancy;
    }

    public Affinity affinity() {
        return Affinity.fromValue(this.affinity);
    }

    public String affinityString() {
        return this.affinity;
    }

    public String hostId() {
        return this.hostId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public HostTenancy tenancy() {
        return HostTenancy.fromValue(this.tenancy);
    }

    public String tenancyString() {
        return this.tenancy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.affinityString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancyString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstancePlacementRequest)) {
            return false;
        }
        ModifyInstancePlacementRequest other = (ModifyInstancePlacementRequest)((Object)obj);
        return Objects.equals(this.affinityString(), other.affinityString()) && Objects.equals(this.hostId(), other.hostId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.tenancyString(), other.tenancyString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.affinityString() != null) {
            sb.append("Affinity: ").append(this.affinityString()).append(",");
        }
        if (this.hostId() != null) {
            sb.append("HostId: ").append(this.hostId()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.tenancyString() != null) {
            sb.append("Tenancy: ").append(this.tenancyString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Affinity": {
                return Optional.of(clazz.cast(this.affinityString()));
            }
            case "HostId": {
                return Optional.of(clazz.cast(this.hostId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Tenancy": {
                return Optional.of(clazz.cast(this.tenancyString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String affinity;
        private String hostId;
        private String instanceId;
        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstancePlacementRequest model) {
            this.affinity(model.affinity);
            this.hostId(model.hostId);
            this.instanceId(model.instanceId);
            this.tenancy(model.tenancy);
        }

        public final String getAffinity() {
            return this.affinity;
        }

        @Override
        public final Builder affinity(String affinity) {
            this.affinity = affinity;
            return this;
        }

        @Override
        public final Builder affinity(Affinity affinity) {
            this.affinity(affinity.toString());
            return this;
        }

        public final void setAffinity(String affinity) {
            this.affinity = affinity;
        }

        public final String getHostId() {
            return this.hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(HostTenancy tenancy) {
            this.tenancy(tenancy.toString());
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public ModifyInstancePlacementRequest build() {
            return new ModifyInstancePlacementRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyInstancePlacementRequest> {
        public Builder affinity(String var1);

        public Builder affinity(Affinity var1);

        public Builder hostId(String var1);

        public Builder instanceId(String var1);

        public Builder tenancy(String var1);

        public Builder tenancy(HostTenancy var1);
    }
}

