/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyIdFormatRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyIdFormatRequest> {
    private final String resource;
    private final Boolean useLongIds;

    private ModifyIdFormatRequest(BuilderImpl builder) {
        this.resource = builder.resource;
        this.useLongIds = builder.useLongIds;
    }

    public String resource() {
        return this.resource;
    }

    public Boolean useLongIds() {
        return this.useLongIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.useLongIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIdFormatRequest)) {
            return false;
        }
        ModifyIdFormatRequest other = (ModifyIdFormatRequest)((Object)obj);
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.useLongIds(), other.useLongIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resource() != null) {
            sb.append("Resource: ").append(this.resource()).append(",");
        }
        if (this.useLongIds() != null) {
            sb.append("UseLongIds: ").append(this.useLongIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Resource": {
                return Optional.of(clazz.cast(this.resource()));
            }
            case "UseLongIds": {
                return Optional.of(clazz.cast(this.useLongIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resource;
        private Boolean useLongIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIdFormatRequest model) {
            this.resource(model.resource);
            this.useLongIds(model.useLongIds);
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final Boolean getUseLongIds() {
            return this.useLongIds;
        }

        @Override
        public final Builder useLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
            return this;
        }

        public final void setUseLongIds(Boolean useLongIds) {
            this.useLongIds = useLongIds;
        }

        public ModifyIdFormatRequest build() {
            return new ModifyIdFormatRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyIdFormatRequest> {
        public Builder resource(String var1);

        public Builder useLongIds(Boolean var1);
    }
}

