/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ClientData;
import software.amazon.awssdk.services.ec2.model.SnapshotDiskContainer;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ImportSnapshotRequest> {
    private final ClientData clientData;
    private final String clientToken;
    private final String description;
    private final SnapshotDiskContainer diskContainer;
    private final String roleName;

    private ImportSnapshotRequest(BuilderImpl builder) {
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainer = builder.diskContainer;
        this.roleName = builder.roleName;
    }

    public ClientData clientData() {
        return this.clientData;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String description() {
        return this.description;
    }

    public SnapshotDiskContainer diskContainer() {
        return this.diskContainer;
    }

    public String roleName() {
        return this.roleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientData());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskContainer());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSnapshotRequest)) {
            return false;
        }
        ImportSnapshotRequest other = (ImportSnapshotRequest)((Object)obj);
        return Objects.equals(this.clientData(), other.clientData()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.diskContainer(), other.diskContainer()) && Objects.equals(this.roleName(), other.roleName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clientData() != null) {
            sb.append("ClientData: ").append(this.clientData()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.diskContainer() != null) {
            sb.append("DiskContainer: ").append(this.diskContainer()).append(",");
        }
        if (this.roleName() != null) {
            sb.append("RoleName: ").append(this.roleName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientData": {
                return Optional.of(clazz.cast(this.clientData()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DiskContainer": {
                return Optional.of(clazz.cast(this.diskContainer()));
            }
            case "RoleName": {
                return Optional.of(clazz.cast(this.roleName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ClientData clientData;
        private String clientToken;
        private String description;
        private SnapshotDiskContainer diskContainer;
        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSnapshotRequest model) {
            this.clientData(model.clientData);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.diskContainer(model.diskContainer);
            this.roleName(model.roleName);
        }

        public final ClientData.Builder getClientData() {
            return this.clientData != null ? this.clientData.toBuilder() : null;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final void setClientData(ClientData.BuilderImpl clientData) {
            this.clientData = clientData != null ? clientData.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final SnapshotDiskContainer.Builder getDiskContainer() {
            return this.diskContainer != null ? this.diskContainer.toBuilder() : null;
        }

        @Override
        public final Builder diskContainer(SnapshotDiskContainer diskContainer) {
            this.diskContainer = diskContainer;
            return this;
        }

        public final void setDiskContainer(SnapshotDiskContainer.BuilderImpl diskContainer) {
            this.diskContainer = diskContainer != null ? diskContainer.build() : null;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public ImportSnapshotRequest build() {
            return new ImportSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportSnapshotRequest> {
        public Builder clientData(ClientData var1);

        default public Builder clientData(Consumer<ClientData.Builder> clientData) {
            return this.clientData((ClientData)((ClientData.Builder)ClientData.builder().apply(clientData)).build());
        }

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder diskContainer(SnapshotDiskContainer var1);

        default public Builder diskContainer(Consumer<SnapshotDiskContainer.Builder> diskContainer) {
            return this.diskContainer((SnapshotDiskContainer)((SnapshotDiskContainer.Builder)SnapshotDiskContainer.builder().apply(diskContainer)).build());
        }

        public Builder roleName(String var1);
    }
}

