/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DisassociateAddressRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DisassociateAddressRequest> {
    private final String associationId;
    private final String publicIp;

    private DisassociateAddressRequest(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.publicIp = builder.publicIp;
    }

    public String associationId() {
        return this.associationId;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateAddressRequest)) {
            return false;
        }
        DisassociateAddressRequest other = (DisassociateAddressRequest)((Object)obj);
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.publicIp(), other.publicIp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.associationId() != null) {
            sb.append("AssociationId: ").append(this.associationId()).append(",");
        }
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateAddressRequest model) {
            this.associationId(model.associationId);
            this.publicIp(model.publicIp);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public DisassociateAddressRequest build() {
            return new DisassociateAddressRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DisassociateAddressRequest> {
        public Builder associationId(String var1);

        public Builder publicIp(String var1);
    }
}

