/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetachInternetGatewayRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DetachInternetGatewayRequest> {
    private final String internetGatewayId;
    private final String vpcId;

    private DetachInternetGatewayRequest(BuilderImpl builder) {
        this.internetGatewayId = builder.internetGatewayId;
        this.vpcId = builder.vpcId;
    }

    public String internetGatewayId() {
        return this.internetGatewayId;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachInternetGatewayRequest)) {
            return false;
        }
        DetachInternetGatewayRequest other = (DetachInternetGatewayRequest)((Object)obj);
        return Objects.equals(this.internetGatewayId(), other.internetGatewayId()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.internetGatewayId() != null) {
            sb.append("InternetGatewayId: ").append(this.internetGatewayId()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InternetGatewayId": {
                return Optional.of(clazz.cast(this.internetGatewayId()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String internetGatewayId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachInternetGatewayRequest model) {
            this.internetGatewayId(model.internetGatewayId);
            this.vpcId(model.vpcId);
        }

        public final String getInternetGatewayId() {
            return this.internetGatewayId;
        }

        @Override
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public DetachInternetGatewayRequest build() {
            return new DetachInternetGatewayRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetachInternetGatewayRequest> {
        public Builder internetGatewayId(String var1);

        public Builder vpcId(String var1);
    }
}

