/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.VpnGateway;
import software.amazon.awssdk.services.ec2.model.VpnGatewayListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpnGatewaysResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVpnGatewaysResponse> {
    private final List<VpnGateway> vpnGateways;

    private DescribeVpnGatewaysResponse(BuilderImpl builder) {
        this.vpnGateways = builder.vpnGateways;
    }

    public List<VpnGateway> vpnGateways() {
        return this.vpnGateways;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnGateways());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnGatewaysResponse)) {
            return false;
        }
        DescribeVpnGatewaysResponse other = (DescribeVpnGatewaysResponse)((Object)obj);
        return Objects.equals(this.vpnGateways(), other.vpnGateways());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.vpnGateways() != null) {
            sb.append("VpnGateways: ").append(this.vpnGateways()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnGateways": {
                return Optional.of(clazz.cast(this.vpnGateways()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<VpnGateway> vpnGateways;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnGatewaysResponse model) {
            this.vpnGateways(model.vpnGateways);
        }

        public final Collection<VpnGateway.Builder> getVpnGateways() {
            return this.vpnGateways != null ? (Collection)this.vpnGateways.stream().map(VpnGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpnGateways(Collection<VpnGateway> vpnGateways) {
            this.vpnGateways = VpnGatewayListCopier.copy(vpnGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnGateways(VpnGateway ... vpnGateways) {
            this.vpnGateways(Arrays.asList(vpnGateways));
            return this;
        }

        public final void setVpnGateways(Collection<VpnGateway.BuilderImpl> vpnGateways) {
            this.vpnGateways = VpnGatewayListCopier.copyFromBuilder(vpnGateways);
        }

        public DescribeVpnGatewaysResponse build() {
            return new DescribeVpnGatewaysResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpnGatewaysResponse> {
        public Builder vpnGateways(Collection<VpnGateway> var1);

        public Builder vpnGateways(VpnGateway ... var1);
    }
}

