/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.ServiceDetail;
import software.amazon.awssdk.services.ec2.model.ServiceDetailSetCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcEndpointServicesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeVpcEndpointServicesResponse> {
    private final List<String> serviceNames;
    private final List<ServiceDetail> serviceDetails;
    private final String nextToken;

    private DescribeVpcEndpointServicesResponse(BuilderImpl builder) {
        this.serviceNames = builder.serviceNames;
        this.serviceDetails = builder.serviceDetails;
        this.nextToken = builder.nextToken;
    }

    public List<String> serviceNames() {
        return this.serviceNames;
    }

    public List<ServiceDetail> serviceDetails() {
        return this.serviceDetails;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointServicesResponse)) {
            return false;
        }
        DescribeVpcEndpointServicesResponse other = (DescribeVpcEndpointServicesResponse)((Object)obj);
        return Objects.equals(this.serviceNames(), other.serviceNames()) && Objects.equals(this.serviceDetails(), other.serviceDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.serviceNames() != null) {
            sb.append("ServiceNames: ").append(this.serviceNames()).append(",");
        }
        if (this.serviceDetails() != null) {
            sb.append("ServiceDetails: ").append(this.serviceDetails()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceNames": {
                return Optional.of(clazz.cast(this.serviceNames()));
            }
            case "ServiceDetails": {
                return Optional.of(clazz.cast(this.serviceDetails()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> serviceNames;
        private List<ServiceDetail> serviceDetails;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointServicesResponse model) {
            this.serviceNames(model.serviceNames);
            this.serviceDetails(model.serviceDetails);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getServiceNames() {
            return this.serviceNames;
        }

        @Override
        public final Builder serviceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNames(String ... serviceNames) {
            this.serviceNames(Arrays.asList(serviceNames));
            return this;
        }

        public final void setServiceNames(Collection<String> serviceNames) {
            this.serviceNames = ValueStringListCopier.copy(serviceNames);
        }

        public final Collection<ServiceDetail.Builder> getServiceDetails() {
            return this.serviceDetails != null ? (Collection)this.serviceDetails.stream().map(ServiceDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceDetails(Collection<ServiceDetail> serviceDetails) {
            this.serviceDetails = ServiceDetailSetCopier.copy(serviceDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDetails(ServiceDetail ... serviceDetails) {
            this.serviceDetails(Arrays.asList(serviceDetails));
            return this;
        }

        public final void setServiceDetails(Collection<ServiceDetail.BuilderImpl> serviceDetails) {
            this.serviceDetails = ServiceDetailSetCopier.copyFromBuilder(serviceDetails);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeVpcEndpointServicesResponse build() {
            return new DescribeVpcEndpointServicesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpcEndpointServicesResponse> {
        public Builder serviceNames(Collection<String> var1);

        public Builder serviceNames(String ... var1);

        public Builder serviceDetails(Collection<ServiceDetail> var1);

        public Builder serviceDetails(ServiceDetail ... var1);

        public Builder nextToken(String var1);
    }
}

