/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.VpcAttributeName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeVpcAttributeRequest> {
    private final String attribute;
    private final String vpcId;

    private DescribeVpcAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.vpcId = builder.vpcId;
    }

    public VpcAttributeName attribute() {
        return VpcAttributeName.fromValue(this.attribute);
    }

    public String attributeString() {
        return this.attribute;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcAttributeRequest)) {
            return false;
        }
        DescribeVpcAttributeRequest other = (DescribeVpcAttributeRequest)((Object)obj);
        return Objects.equals(this.attributeString(), other.attributeString()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attributeString() != null) {
            sb.append("Attribute: ").append(this.attributeString()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.of(clazz.cast(this.attributeString()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcAttributeRequest model) {
            this.attribute(model.attribute);
            this.vpcId(model.vpcId);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(VpcAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public DescribeVpcAttributeRequest build() {
            return new DescribeVpcAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpcAttributeRequest> {
        public Builder attribute(String var1);

        public Builder attribute(VpcAttributeName var1);

        public Builder vpcId(String var1);
    }
}

