/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;
import software.amazon.awssdk.services.ec2.model.SecurityGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSecurityGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSecurityGroupsResponse> {
    private final List<SecurityGroup> securityGroups;
    private final String nextToken;

    private DescribeSecurityGroupsResponse(BuilderImpl builder) {
        this.securityGroups = builder.securityGroups;
        this.nextToken = builder.nextToken;
    }

    public List<SecurityGroup> securityGroups() {
        return this.securityGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupsResponse)) {
            return false;
        }
        DescribeSecurityGroupsResponse other = (DescribeSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroups": {
                return Optional.of(clazz.cast(this.securityGroups()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<SecurityGroup> securityGroups;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupsResponse model) {
            this.securityGroups(model.securityGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<SecurityGroup.Builder> getSecurityGroups() {
            return this.securityGroups != null ? (Collection)this.securityGroups.stream().map(SecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroup> securityGroups) {
            this.securityGroups = SecurityGroupListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroup ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<SecurityGroup.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupListCopier.copyFromBuilder(securityGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeSecurityGroupsResponse build() {
            return new DescribeSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSecurityGroupsResponse> {
        public Builder securityGroups(Collection<SecurityGroup> var1);

        public Builder securityGroups(SecurityGroup ... var1);

        public Builder nextToken(String var1);
    }
}

