/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNatGatewaysRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeNatGatewaysRequest> {
    private final List<Filter> filter;
    private final Integer maxResults;
    private final List<String> natGatewayIds;
    private final String nextToken;

    private DescribeNatGatewaysRequest(BuilderImpl builder) {
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.natGatewayIds = builder.natGatewayIds;
        this.nextToken = builder.nextToken;
    }

    public List<Filter> filter() {
        return this.filter;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public List<String> natGatewayIds() {
        return this.natGatewayIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNatGatewaysRequest)) {
            return false;
        }
        DescribeNatGatewaysRequest other = (DescribeNatGatewaysRequest)((Object)obj);
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.natGatewayIds(), other.natGatewayIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.natGatewayIds() != null) {
            sb.append("NatGatewayIds: ").append(this.natGatewayIds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NatGatewayIds": {
                return Optional.of(clazz.cast(this.natGatewayIds()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Filter> filter;
        private Integer maxResults;
        private List<String> natGatewayIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNatGatewaysRequest model) {
            this.filter(model.filter);
            this.maxResults(model.maxResults);
            this.natGatewayIds(model.natGatewayIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilter() {
            return this.filter != null ? (Collection)this.filter.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter ... filter) {
            this.filter(Arrays.asList(filter));
            return this;
        }

        public final void setFilter(Collection<Filter.BuilderImpl> filter) {
            this.filter = FilterListCopier.copyFromBuilder(filter);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<String> getNatGatewayIds() {
            return this.natGatewayIds;
        }

        @Override
        public final Builder natGatewayIds(Collection<String> natGatewayIds) {
            this.natGatewayIds = ValueStringListCopier.copy(natGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayIds(String ... natGatewayIds) {
            this.natGatewayIds(Arrays.asList(natGatewayIds));
            return this;
        }

        public final void setNatGatewayIds(Collection<String> natGatewayIds) {
            this.natGatewayIds = ValueStringListCopier.copy(natGatewayIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeNatGatewaysRequest build() {
            return new DescribeNatGatewaysRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNatGatewaysRequest> {
        public Builder filter(Collection<Filter> var1);

        public Builder filter(Filter ... var1);

        public Builder maxResults(Integer var1);

        public Builder natGatewayIds(Collection<String> var1);

        public Builder natGatewayIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

