/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.InstanceStatus;
import software.amazon.awssdk.services.ec2.model.InstanceStatusListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceStatusResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstanceStatusResponse> {
    private final List<InstanceStatus> instanceStatuses;
    private final String nextToken;

    private DescribeInstanceStatusResponse(BuilderImpl builder) {
        this.instanceStatuses = builder.instanceStatuses;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceStatus> instanceStatuses() {
        return this.instanceStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatuses());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceStatusResponse)) {
            return false;
        }
        DescribeInstanceStatusResponse other = (DescribeInstanceStatusResponse)((Object)obj);
        return Objects.equals(this.instanceStatuses(), other.instanceStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceStatuses() != null) {
            sb.append("InstanceStatuses: ").append(this.instanceStatuses()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceStatuses": {
                return Optional.of(clazz.cast(this.instanceStatuses()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstanceStatus> instanceStatuses;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceStatusResponse model) {
            this.instanceStatuses(model.instanceStatuses);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceStatus.Builder> getInstanceStatuses() {
            return this.instanceStatuses != null ? (Collection)this.instanceStatuses.stream().map(InstanceStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceStatuses(Collection<InstanceStatus> instanceStatuses) {
            this.instanceStatuses = InstanceStatusListCopier.copy(instanceStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatuses(InstanceStatus ... instanceStatuses) {
            this.instanceStatuses(Arrays.asList(instanceStatuses));
            return this;
        }

        public final void setInstanceStatuses(Collection<InstanceStatus.BuilderImpl> instanceStatuses) {
            this.instanceStatuses = InstanceStatusListCopier.copyFromBuilder(instanceStatuses);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstanceStatusResponse build() {
            return new DescribeInstanceStatusResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstanceStatusResponse> {
        public Builder instanceStatuses(Collection<InstanceStatus> var1);

        public Builder instanceStatuses(InstanceStatus ... var1);

        public Builder nextToken(String var1);
    }
}

