/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSetCopier;
import software.amazon.awssdk.services.ec2.model.ElasticGpus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticGpusResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeElasticGpusResponse> {
    private final List<ElasticGpus> elasticGpuSet;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeElasticGpusResponse(BuilderImpl builder) {
        this.elasticGpuSet = builder.elasticGpuSet;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<ElasticGpus> elasticGpuSet() {
        return this.elasticGpuSet;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticGpuSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticGpusResponse)) {
            return false;
        }
        DescribeElasticGpusResponse other = (DescribeElasticGpusResponse)((Object)obj);
        return Objects.equals(this.elasticGpuSet(), other.elasticGpuSet()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.elasticGpuSet() != null) {
            sb.append("ElasticGpuSet: ").append(this.elasticGpuSet()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticGpuSet": {
                return Optional.of(clazz.cast(this.elasticGpuSet()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ElasticGpus> elasticGpuSet;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticGpusResponse model) {
            this.elasticGpuSet(model.elasticGpuSet);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<ElasticGpus.Builder> getElasticGpuSet() {
            return this.elasticGpuSet != null ? (Collection)this.elasticGpuSet.stream().map(ElasticGpus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticGpuSet(Collection<ElasticGpus> elasticGpuSet) {
            this.elasticGpuSet = ElasticGpuSetCopier.copy(elasticGpuSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSet(ElasticGpus ... elasticGpuSet) {
            this.elasticGpuSet(Arrays.asList(elasticGpuSet));
            return this;
        }

        public final void setElasticGpuSet(Collection<ElasticGpus.BuilderImpl> elasticGpuSet) {
            this.elasticGpuSet = ElasticGpuSetCopier.copyFromBuilder(elasticGpuSet);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeElasticGpusResponse build() {
            return new DescribeElasticGpusResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeElasticGpusResponse> {
        public Builder elasticGpuSet(Collection<ElasticGpus> var1);

        public Builder elasticGpuSet(ElasticGpus ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

