/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteFlowLogsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteFlowLogsRequest> {
    private final List<String> flowLogIds;

    private DeleteFlowLogsRequest(BuilderImpl builder) {
        this.flowLogIds = builder.flowLogIds;
    }

    public List<String> flowLogIds() {
        return this.flowLogIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFlowLogsRequest)) {
            return false;
        }
        DeleteFlowLogsRequest other = (DeleteFlowLogsRequest)((Object)obj);
        return Objects.equals(this.flowLogIds(), other.flowLogIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.flowLogIds() != null) {
            sb.append("FlowLogIds: ").append(this.flowLogIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowLogIds": {
                return Optional.of(clazz.cast(this.flowLogIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> flowLogIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFlowLogsRequest model) {
            this.flowLogIds(model.flowLogIds);
        }

        public final Collection<String> getFlowLogIds() {
            return this.flowLogIds;
        }

        @Override
        public final Builder flowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogIds(String ... flowLogIds) {
            this.flowLogIds(Arrays.asList(flowLogIds));
            return this;
        }

        public final void setFlowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
        }

        public DeleteFlowLogsRequest build() {
            return new DeleteFlowLogsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteFlowLogsRequest> {
        public Builder flowLogIds(Collection<String> var1);

        public Builder flowLogIds(String ... var1);
    }
}

