/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopySnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CopySnapshotRequest> {
    private final String description;
    private final String destinationRegion;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String presignedUrl;
    private final String sourceRegion;
    private final String sourceSnapshotId;

    private CopySnapshotRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.destinationRegion = builder.destinationRegion;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.presignedUrl = builder.presignedUrl;
        this.sourceRegion = builder.sourceRegion;
        this.sourceSnapshotId = builder.sourceSnapshotId;
    }

    public String description() {
        return this.description;
    }

    public String destinationRegion() {
        return this.destinationRegion;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String presignedUrl() {
        return this.presignedUrl;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public String sourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.presignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.presignedUrl(), other.presignedUrl()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.sourceSnapshotId(), other.sourceSnapshotId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.destinationRegion() != null) {
            sb.append("DestinationRegion: ").append(this.destinationRegion()).append(",");
        }
        if (this.encrypted() != null) {
            sb.append("Encrypted: ").append(this.encrypted()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.presignedUrl() != null) {
            sb.append("PresignedUrl: ").append(this.presignedUrl()).append(",");
        }
        if (this.sourceRegion() != null) {
            sb.append("SourceRegion: ").append(this.sourceRegion()).append(",");
        }
        if (this.sourceSnapshotId() != null) {
            sb.append("SourceSnapshotId: ").append(this.sourceSnapshotId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DestinationRegion": {
                return Optional.of(clazz.cast(this.destinationRegion()));
            }
            case "Encrypted": {
                return Optional.of(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "PresignedUrl": {
                return Optional.of(clazz.cast(this.presignedUrl()));
            }
            case "SourceRegion": {
                return Optional.of(clazz.cast(this.sourceRegion()));
            }
            case "SourceSnapshotId": {
                return Optional.of(clazz.cast(this.sourceSnapshotId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String destinationRegion;
        private Boolean encrypted;
        private String kmsKeyId;
        private String presignedUrl;
        private String sourceRegion;
        private String sourceSnapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            this.description(model.description);
            this.destinationRegion(model.destinationRegion);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.presignedUrl(model.presignedUrl);
            this.sourceRegion(model.sourceRegion);
            this.sourceSnapshotId(model.sourceSnapshotId);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getPresignedUrl() {
            return this.presignedUrl;
        }

        @Override
        public final Builder presignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
            return this;
        }

        public final void setPresignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getSourceSnapshotId() {
            return this.sourceSnapshotId;
        }

        @Override
        public final Builder sourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
            return this;
        }

        public final void setSourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
        }

        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CopySnapshotRequest> {
        public Builder description(String var1);

        public Builder destinationRegion(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder presignedUrl(String var1);

        public Builder sourceRegion(String var1);

        public Builder sourceSnapshotId(String var1);
    }
}

