/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyFpgaImageRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CopyFpgaImageRequest> {
    private final String sourceFpgaImageId;
    private final String description;
    private final String name;
    private final String sourceRegion;
    private final String clientToken;

    private CopyFpgaImageRequest(BuilderImpl builder) {
        this.sourceFpgaImageId = builder.sourceFpgaImageId;
        this.description = builder.description;
        this.name = builder.name;
        this.sourceRegion = builder.sourceRegion;
        this.clientToken = builder.clientToken;
    }

    public String sourceFpgaImageId() {
        return this.sourceFpgaImageId;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyFpgaImageRequest)) {
            return false;
        }
        CopyFpgaImageRequest other = (CopyFpgaImageRequest)((Object)obj);
        return Objects.equals(this.sourceFpgaImageId(), other.sourceFpgaImageId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceFpgaImageId() != null) {
            sb.append("SourceFpgaImageId: ").append(this.sourceFpgaImageId()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.sourceRegion() != null) {
            sb.append("SourceRegion: ").append(this.sourceRegion()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceFpgaImageId": {
                return Optional.of(clazz.cast(this.sourceFpgaImageId()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "SourceRegion": {
                return Optional.of(clazz.cast(this.sourceRegion()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceFpgaImageId;
        private String description;
        private String name;
        private String sourceRegion;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyFpgaImageRequest model) {
            this.sourceFpgaImageId(model.sourceFpgaImageId);
            this.description(model.description);
            this.name(model.name);
            this.sourceRegion(model.sourceRegion);
            this.clientToken(model.clientToken);
        }

        public final String getSourceFpgaImageId() {
            return this.sourceFpgaImageId;
        }

        @Override
        public final Builder sourceFpgaImageId(String sourceFpgaImageId) {
            this.sourceFpgaImageId = sourceFpgaImageId;
            return this;
        }

        public final void setSourceFpgaImageId(String sourceFpgaImageId) {
            this.sourceFpgaImageId = sourceFpgaImageId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public CopyFpgaImageRequest build() {
            return new CopyFpgaImageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CopyFpgaImageRequest> {
        public Builder sourceFpgaImageId(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder sourceRegion(String var1);

        public Builder clientToken(String var1);
    }
}

