/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ConfirmProductInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ConfirmProductInstanceRequest> {
    private final String instanceId;
    private final String productCode;

    private ConfirmProductInstanceRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.productCode = builder.productCode;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String productCode() {
        return this.productCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmProductInstanceRequest)) {
            return false;
        }
        ConfirmProductInstanceRequest other = (ConfirmProductInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.productCode(), other.productCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.productCode() != null) {
            sb.append("ProductCode: ").append(this.productCode()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "ProductCode": {
                return Optional.of(clazz.cast(this.productCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String productCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmProductInstanceRequest model) {
            this.instanceId(model.instanceId);
            this.productCode(model.productCode);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getProductCode() {
            return this.productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        public ConfirmProductInstanceRequest build() {
            return new ConfirmProductInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ConfirmProductInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder productCode(String var1);
    }
}

