/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CancelSpotFleetRequestsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CancelSpotFleetRequestsRequest> {
    private final List<String> spotFleetRequestIds;
    private final Boolean terminateInstances;

    private CancelSpotFleetRequestsRequest(BuilderImpl builder) {
        this.spotFleetRequestIds = builder.spotFleetRequestIds;
        this.terminateInstances = builder.terminateInstances;
    }

    public List<String> spotFleetRequestIds() {
        return this.spotFleetRequestIds;
    }

    public Boolean terminateInstances() {
        return this.terminateInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsRequest)) {
            return false;
        }
        CancelSpotFleetRequestsRequest other = (CancelSpotFleetRequestsRequest)((Object)obj);
        return Objects.equals(this.spotFleetRequestIds(), other.spotFleetRequestIds()) && Objects.equals(this.terminateInstances(), other.terminateInstances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.spotFleetRequestIds() != null) {
            sb.append("SpotFleetRequestIds: ").append(this.spotFleetRequestIds()).append(",");
        }
        if (this.terminateInstances() != null) {
            sb.append("TerminateInstances: ").append(this.terminateInstances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotFleetRequestIds": {
                return Optional.of(clazz.cast(this.spotFleetRequestIds()));
            }
            case "TerminateInstances": {
                return Optional.of(clazz.cast(this.terminateInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> spotFleetRequestIds;
        private Boolean terminateInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsRequest model) {
            this.spotFleetRequestIds(model.spotFleetRequestIds);
            this.terminateInstances(model.terminateInstances);
        }

        public final Collection<String> getSpotFleetRequestIds() {
            return this.spotFleetRequestIds;
        }

        @Override
        public final Builder spotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = ValueStringListCopier.copy(spotFleetRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestIds(String ... spotFleetRequestIds) {
            this.spotFleetRequestIds(Arrays.asList(spotFleetRequestIds));
            return this;
        }

        public final void setSpotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = ValueStringListCopier.copy(spotFleetRequestIds);
        }

        public final Boolean getTerminateInstances() {
            return this.terminateInstances;
        }

        @Override
        public final Builder terminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
            return this;
        }

        public final void setTerminateInstances(Boolean terminateInstances) {
            this.terminateInstances = terminateInstances;
        }

        public CancelSpotFleetRequestsRequest build() {
            return new CancelSpotFleetRequestsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CancelSpotFleetRequestsRequest> {
        public Builder spotFleetRequestIds(Collection<String> var1);

        public Builder spotFleetRequestIds(String ... var1);

        public Builder terminateInstances(Boolean var1);
    }
}

