/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.DomainType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Address
implements ToCopyableBuilder<Builder, Address> {
    private final String instanceId;
    private final String publicIp;
    private final String allocationId;
    private final String associationId;
    private final String domain;
    private final String networkInterfaceId;
    private final String networkInterfaceOwnerId;
    private final String privateIpAddress;

    private Address(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.associationId = builder.associationId;
        this.domain = builder.domain;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkInterfaceOwnerId = builder.networkInterfaceOwnerId;
        this.privateIpAddress = builder.privateIpAddress;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public String associationId() {
        return this.associationId;
    }

    public DomainType domain() {
        return DomainType.fromValue(this.domain);
    }

    public String domainString() {
        return this.domain;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String networkInterfaceOwnerId() {
        return this.networkInterfaceOwnerId;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.domainString(), other.domainString()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.networkInterfaceOwnerId(), other.networkInterfaceOwnerId()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (this.allocationId() != null) {
            sb.append("AllocationId: ").append(this.allocationId()).append(",");
        }
        if (this.associationId() != null) {
            sb.append("AssociationId: ").append(this.associationId()).append(",");
        }
        if (this.domainString() != null) {
            sb.append("Domain: ").append(this.domainString()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.networkInterfaceOwnerId() != null) {
            sb.append("NetworkInterfaceOwnerId: ").append(this.networkInterfaceOwnerId()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
            case "AllocationId": {
                return Optional.of(clazz.cast(this.allocationId()));
            }
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "Domain": {
                return Optional.of(clazz.cast(this.domainString()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "NetworkInterfaceOwnerId": {
                return Optional.of(clazz.cast(this.networkInterfaceOwnerId()));
            }
            case "PrivateIpAddress": {
                return Optional.of(clazz.cast(this.privateIpAddress()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String publicIp;
        private String allocationId;
        private String associationId;
        private String domain;
        private String networkInterfaceId;
        private String networkInterfaceOwnerId;
        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            this.instanceId(model.instanceId);
            this.publicIp(model.publicIp);
            this.allocationId(model.allocationId);
            this.associationId(model.associationId);
            this.domain(model.domain);
            this.networkInterfaceId(model.networkInterfaceId);
            this.networkInterfaceOwnerId(model.networkInterfaceOwnerId);
            this.privateIpAddress(model.privateIpAddress);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getNetworkInterfaceOwnerId() {
            return this.networkInterfaceOwnerId;
        }

        @Override
        public final Builder networkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
            return this;
        }

        public final void setNetworkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public Address build() {
            return new Address(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Address> {
        public Builder instanceId(String var1);

        public Builder publicIp(String var1);

        public Builder allocationId(String var1);

        public Builder associationId(String var1);

        public Builder domain(String var1);

        public Builder domain(DomainType var1);

        public Builder networkInterfaceId(String var1);

        public Builder networkInterfaceOwnerId(String var1);

        public Builder privateIpAddress(String var1);
    }
}

