/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest;

public class ReplaceRouteTableAssociationRequestMarshaller
implements Marshaller<Request<ReplaceRouteTableAssociationRequest>, ReplaceRouteTableAssociationRequest> {
    public Request<ReplaceRouteTableAssociationRequest> marshall(ReplaceRouteTableAssociationRequest replaceRouteTableAssociationRequest) {
        if (replaceRouteTableAssociationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceRouteTableAssociationRequest, "EC2Client");
        request.addParameter("Action", "ReplaceRouteTableAssociation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceRouteTableAssociationRequest.associationId() != null) {
            request.addParameter("AssociationId", StringUtils.fromString((String)replaceRouteTableAssociationRequest.associationId()));
        }
        if (replaceRouteTableAssociationRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString((String)replaceRouteTableAssociationRequest.routeTableId()));
        }
        return request;
    }
}

