/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CopySnapshotRequest;

public class CopySnapshotRequestMarshaller
implements Marshaller<Request<CopySnapshotRequest>, CopySnapshotRequest> {
    public Request<CopySnapshotRequest> marshall(CopySnapshotRequest copySnapshotRequest) {
        if (copySnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copySnapshotRequest, "EC2Client");
        request.addParameter("Action", "CopySnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (copySnapshotRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)copySnapshotRequest.description()));
        }
        if (copySnapshotRequest.destinationRegion() != null) {
            request.addParameter("DestinationRegion", StringUtils.fromString((String)copySnapshotRequest.destinationRegion()));
        }
        if (copySnapshotRequest.encrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean((Boolean)copySnapshotRequest.encrypted()));
        }
        if (copySnapshotRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)copySnapshotRequest.kmsKeyId()));
        }
        if (copySnapshotRequest.presignedUrl() != null) {
            request.addParameter("PresignedUrl", StringUtils.fromString((String)copySnapshotRequest.presignedUrl()));
        }
        if (copySnapshotRequest.sourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString((String)copySnapshotRequest.sourceRegion()));
        }
        if (copySnapshotRequest.sourceSnapshotId() != null) {
            request.addParameter("SourceSnapshotId", StringUtils.fromString((String)copySnapshotRequest.sourceSnapshotId()));
        }
        return request;
    }
}

