/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeStatusAction
implements ToCopyableBuilder<Builder, VolumeStatusAction> {
    private final String code;
    private final String description;
    private final String eventId;
    private final String eventType;

    private VolumeStatusAction(BuilderImpl builder) {
        this.code = builder.code;
        this.description = builder.description;
        this.eventId = builder.eventId;
        this.eventType = builder.eventType;
    }

    public String code() {
        return this.code;
    }

    public String description() {
        return this.description;
    }

    public String eventId() {
        return this.eventId;
    }

    public String eventType() {
        return this.eventType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.code() == null ? 0 : this.code().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.eventId() == null ? 0 : this.eventId().hashCode());
        hashCode = 31 * hashCode + (this.eventType() == null ? 0 : this.eventType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusAction)) {
            return false;
        }
        VolumeStatusAction other = (VolumeStatusAction)obj;
        if (other.code() == null ^ this.code() == null) {
            return false;
        }
        if (other.code() != null && !other.code().equals(this.code())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.eventId() == null ^ this.eventId() == null) {
            return false;
        }
        if (other.eventId() != null && !other.eventId().equals(this.eventId())) {
            return false;
        }
        if (other.eventType() == null ^ this.eventType() == null) {
            return false;
        }
        return other.eventType() == null || other.eventType().equals(this.eventType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.code() != null) {
            sb.append("Code: ").append(this.code()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.eventId() != null) {
            sb.append("EventId: ").append(this.eventId()).append(",");
        }
        if (this.eventType() != null) {
            sb.append("EventType: ").append(this.eventType()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.of(clazz.cast(this.code()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "EventId": {
                return Optional.of(clazz.cast(this.eventId()));
            }
            case "EventType": {
                return Optional.of(clazz.cast(this.eventType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String description;
        private String eventId;
        private String eventType;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusAction model) {
            this.code(model.code);
            this.description(model.description);
            this.eventId(model.eventId);
            this.eventType(model.eventType);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public VolumeStatusAction build() {
            return new VolumeStatusAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeStatusAction> {
        public Builder code(String var1);

        public Builder description(String var1);

        public Builder eventId(String var1);

        public Builder eventType(String var1);
    }
}

