/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.LaunchSpecification;
import software.amazon.awssdk.services.ec2.model.SpotInstanceType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RequestSpotInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RequestSpotInstancesRequest> {
    private final String availabilityZoneGroup;
    private final Integer blockDurationMinutes;
    private final String clientToken;
    private final Integer instanceCount;
    private final String launchGroup;
    private final LaunchSpecification launchSpecification;
    private final String spotPrice;
    private final String type;
    private final Instant validFrom;
    private final Instant validUntil;

    private RequestSpotInstancesRequest(BuilderImpl builder) {
        this.availabilityZoneGroup = builder.availabilityZoneGroup;
        this.blockDurationMinutes = builder.blockDurationMinutes;
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.launchGroup = builder.launchGroup;
        this.launchSpecification = builder.launchSpecification;
        this.spotPrice = builder.spotPrice;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
    }

    public String availabilityZoneGroup() {
        return this.availabilityZoneGroup;
    }

    public Integer blockDurationMinutes() {
        return this.blockDurationMinutes;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public String launchGroup() {
        return this.launchGroup;
    }

    public LaunchSpecification launchSpecification() {
        return this.launchSpecification;
    }

    public String spotPrice() {
        return this.spotPrice;
    }

    public SpotInstanceType type() {
        return SpotInstanceType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Instant validFrom() {
        return this.validFrom;
    }

    public Instant validUntil() {
        return this.validUntil;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZoneGroup() == null ? 0 : this.availabilityZoneGroup().hashCode());
        hashCode = 31 * hashCode + (this.blockDurationMinutes() == null ? 0 : this.blockDurationMinutes().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.launchGroup() == null ? 0 : this.launchGroup().hashCode());
        hashCode = 31 * hashCode + (this.launchSpecification() == null ? 0 : this.launchSpecification().hashCode());
        hashCode = 31 * hashCode + (this.spotPrice() == null ? 0 : this.spotPrice().hashCode());
        hashCode = 31 * hashCode + (this.typeString() == null ? 0 : this.typeString().hashCode());
        hashCode = 31 * hashCode + (this.validFrom() == null ? 0 : this.validFrom().hashCode());
        hashCode = 31 * hashCode + (this.validUntil() == null ? 0 : this.validUntil().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotInstancesRequest)) {
            return false;
        }
        RequestSpotInstancesRequest other = (RequestSpotInstancesRequest)((Object)obj);
        if (other.availabilityZoneGroup() == null ^ this.availabilityZoneGroup() == null) {
            return false;
        }
        if (other.availabilityZoneGroup() != null && !other.availabilityZoneGroup().equals(this.availabilityZoneGroup())) {
            return false;
        }
        if (other.blockDurationMinutes() == null ^ this.blockDurationMinutes() == null) {
            return false;
        }
        if (other.blockDurationMinutes() != null && !other.blockDurationMinutes().equals(this.blockDurationMinutes())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.launchGroup() == null ^ this.launchGroup() == null) {
            return false;
        }
        if (other.launchGroup() != null && !other.launchGroup().equals(this.launchGroup())) {
            return false;
        }
        if (other.launchSpecification() == null ^ this.launchSpecification() == null) {
            return false;
        }
        if (other.launchSpecification() != null && !other.launchSpecification().equals(this.launchSpecification())) {
            return false;
        }
        if (other.spotPrice() == null ^ this.spotPrice() == null) {
            return false;
        }
        if (other.spotPrice() != null && !other.spotPrice().equals(this.spotPrice())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.validFrom() == null ^ this.validFrom() == null) {
            return false;
        }
        if (other.validFrom() != null && !other.validFrom().equals(this.validFrom())) {
            return false;
        }
        if (other.validUntil() == null ^ this.validUntil() == null) {
            return false;
        }
        return other.validUntil() == null || other.validUntil().equals(this.validUntil());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.availabilityZoneGroup() != null) {
            sb.append("AvailabilityZoneGroup: ").append(this.availabilityZoneGroup()).append(",");
        }
        if (this.blockDurationMinutes() != null) {
            sb.append("BlockDurationMinutes: ").append(this.blockDurationMinutes()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.launchGroup() != null) {
            sb.append("LaunchGroup: ").append(this.launchGroup()).append(",");
        }
        if (this.launchSpecification() != null) {
            sb.append("LaunchSpecification: ").append(this.launchSpecification()).append(",");
        }
        if (this.spotPrice() != null) {
            sb.append("SpotPrice: ").append(this.spotPrice()).append(",");
        }
        if (this.typeString() != null) {
            sb.append("Type: ").append(this.typeString()).append(",");
        }
        if (this.validFrom() != null) {
            sb.append("ValidFrom: ").append(this.validFrom()).append(",");
        }
        if (this.validUntil() != null) {
            sb.append("ValidUntil: ").append(this.validUntil()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZoneGroup": {
                return Optional.of(clazz.cast(this.availabilityZoneGroup()));
            }
            case "BlockDurationMinutes": {
                return Optional.of(clazz.cast(this.blockDurationMinutes()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "InstanceCount": {
                return Optional.of(clazz.cast(this.instanceCount()));
            }
            case "LaunchGroup": {
                return Optional.of(clazz.cast(this.launchGroup()));
            }
            case "LaunchSpecification": {
                return Optional.of(clazz.cast(this.launchSpecification()));
            }
            case "SpotPrice": {
                return Optional.of(clazz.cast(this.spotPrice()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
            case "ValidFrom": {
                return Optional.of(clazz.cast(this.validFrom()));
            }
            case "ValidUntil": {
                return Optional.of(clazz.cast(this.validUntil()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZoneGroup;
        private Integer blockDurationMinutes;
        private String clientToken;
        private Integer instanceCount;
        private String launchGroup;
        private LaunchSpecification launchSpecification;
        private String spotPrice;
        private String type;
        private Instant validFrom;
        private Instant validUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotInstancesRequest model) {
            this.availabilityZoneGroup(model.availabilityZoneGroup);
            this.blockDurationMinutes(model.blockDurationMinutes);
            this.clientToken(model.clientToken);
            this.instanceCount(model.instanceCount);
            this.launchGroup(model.launchGroup);
            this.launchSpecification(model.launchSpecification);
            this.spotPrice(model.spotPrice);
            this.type(model.type);
            this.validFrom(model.validFrom);
            this.validUntil(model.validUntil);
        }

        public final String getAvailabilityZoneGroup() {
            return this.availabilityZoneGroup;
        }

        @Override
        public final Builder availabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
            return this;
        }

        public final void setAvailabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
        }

        public final Integer getBlockDurationMinutes() {
            return this.blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getLaunchGroup() {
            return this.launchGroup;
        }

        @Override
        public final Builder launchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
            return this;
        }

        public final void setLaunchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
        }

        public final LaunchSpecification.Builder getLaunchSpecification() {
            return this.launchSpecification != null ? this.launchSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecification(LaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(LaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        public final String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SpotInstanceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return this.validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return this.validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public RequestSpotInstancesRequest build() {
            return new RequestSpotInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RequestSpotInstancesRequest> {
        public Builder availabilityZoneGroup(String var1);

        public Builder blockDurationMinutes(Integer var1);

        public Builder clientToken(String var1);

        public Builder instanceCount(Integer var1);

        public Builder launchGroup(String var1);

        public Builder launchSpecification(LaunchSpecification var1);

        public Builder spotPrice(String var1);

        public Builder type(String var1);

        public Builder type(SpotInstanceType var1);

        public Builder validFrom(Instant var1);

        public Builder validUntil(Instant var1);
    }
}

