/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.ec2.model.InstanceIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.ReasonCodesListCopier;
import software.amazon.awssdk.services.ec2.model.ReportInstanceReasonCodes;
import software.amazon.awssdk.services.ec2.model.ReportStatusType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReportInstanceStatusRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ReportInstanceStatusRequest> {
    private final String description;
    private final Instant endTime;
    private final List<String> instances;
    private final List<String> reasonCodes;
    private final Instant startTime;
    private final String status;

    private ReportInstanceStatusRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.endTime = builder.endTime;
        this.instances = builder.instances;
        this.reasonCodes = builder.reasonCodes;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    public String description() {
        return this.description;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public List<String> instances() {
        return this.instances;
    }

    public List<ReportInstanceReasonCodes> reasonCodes() {
        return TypeConverter.convert(this.reasonCodes, ReportInstanceReasonCodes::fromValue);
    }

    public List<String> reasonCodesStrings() {
        return this.reasonCodes;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public ReportStatusType status() {
        return ReportStatusType.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.instances() == null ? 0 : this.instances().hashCode());
        hashCode = 31 * hashCode + (this.reasonCodesStrings() == null ? 0 : this.reasonCodesStrings().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.statusString() == null ? 0 : this.statusString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportInstanceStatusRequest)) {
            return false;
        }
        ReportInstanceStatusRequest other = (ReportInstanceStatusRequest)((Object)obj);
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.reasonCodesStrings() == null ^ this.reasonCodesStrings() == null) {
            return false;
        }
        if (other.reasonCodesStrings() != null && !other.reasonCodesStrings().equals(this.reasonCodesStrings())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.statusString() == null ^ this.statusString() == null) {
            return false;
        }
        return other.statusString() == null || other.statusString().equals(this.statusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (this.reasonCodesStrings() != null) {
            sb.append("ReasonCodes: ").append(this.reasonCodesStrings()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "Instances": {
                return Optional.of(clazz.cast(this.instances()));
            }
            case "ReasonCodes": {
                return Optional.of(clazz.cast(this.reasonCodesStrings()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private Instant endTime;
        private List<String> instances;
        private List<String> reasonCodes;
        private Instant startTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportInstanceStatusRequest model) {
            this.description(model.description);
            this.endTime(model.endTime);
            this.instances(model.instances);
            this.reasonCodes(model.reasonCodes);
            this.startTime(model.startTime);
            this.status(model.status);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<String> getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
        }

        public final Collection<String> getReasonCodes() {
            return this.reasonCodes;
        }

        @Override
        public final Builder reasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodes(String ... reasonCodes) {
            this.reasonCodes(Arrays.asList(reasonCodes));
            return this;
        }

        public final void setReasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReportStatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ReportInstanceStatusRequest build() {
            return new ReportInstanceStatusRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReportInstanceStatusRequest> {
        public Builder description(String var1);

        public Builder endTime(Instant var1);

        public Builder instances(Collection<String> var1);

        public Builder instances(String ... var1);

        public Builder reasonCodes(Collection<String> var1);

        public Builder reasonCodes(String ... var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ReportStatusType var1);
    }
}

