/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KeyPairInfo
implements ToCopyableBuilder<Builder, KeyPairInfo> {
    private final String keyFingerprint;
    private final String keyName;

    private KeyPairInfo(BuilderImpl builder) {
        this.keyFingerprint = builder.keyFingerprint;
        this.keyName = builder.keyName;
    }

    public String keyFingerprint() {
        return this.keyFingerprint;
    }

    public String keyName() {
        return this.keyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyFingerprint() == null ? 0 : this.keyFingerprint().hashCode());
        hashCode = 31 * hashCode + (this.keyName() == null ? 0 : this.keyName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPairInfo)) {
            return false;
        }
        KeyPairInfo other = (KeyPairInfo)obj;
        if (other.keyFingerprint() == null ^ this.keyFingerprint() == null) {
            return false;
        }
        if (other.keyFingerprint() != null && !other.keyFingerprint().equals(this.keyFingerprint())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        return other.keyName() == null || other.keyName().equals(this.keyName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.keyFingerprint() != null) {
            sb.append("KeyFingerprint: ").append(this.keyFingerprint()).append(",");
        }
        if (this.keyName() != null) {
            sb.append("KeyName: ").append(this.keyName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyFingerprint": {
                return Optional.of(clazz.cast(this.keyFingerprint()));
            }
            case "KeyName": {
                return Optional.of(clazz.cast(this.keyName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String keyFingerprint;
        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPairInfo model) {
            this.keyFingerprint(model.keyFingerprint);
            this.keyName(model.keyName);
        }

        public final String getKeyFingerprint() {
            return this.keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public KeyPairInfo build() {
            return new KeyPairInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeyPairInfo> {
        public Builder keyFingerprint(String var1);

        public Builder keyName(String var1);
    }
}

