/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.AllocationState;
import software.amazon.awssdk.services.ec2.model.AutoPlacement;
import software.amazon.awssdk.services.ec2.model.AvailableCapacity;
import software.amazon.awssdk.services.ec2.model.HostInstance;
import software.amazon.awssdk.services.ec2.model.HostInstanceListCopier;
import software.amazon.awssdk.services.ec2.model.HostProperties;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Host
implements ToCopyableBuilder<Builder, Host> {
    private final String autoPlacement;
    private final String availabilityZone;
    private final AvailableCapacity availableCapacity;
    private final String clientToken;
    private final String hostId;
    private final HostProperties hostProperties;
    private final String hostReservationId;
    private final List<HostInstance> instances;
    private final String state;

    private Host(BuilderImpl builder) {
        this.autoPlacement = builder.autoPlacement;
        this.availabilityZone = builder.availabilityZone;
        this.availableCapacity = builder.availableCapacity;
        this.clientToken = builder.clientToken;
        this.hostId = builder.hostId;
        this.hostProperties = builder.hostProperties;
        this.hostReservationId = builder.hostReservationId;
        this.instances = builder.instances;
        this.state = builder.state;
    }

    public AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(this.autoPlacement);
    }

    public String autoPlacementString() {
        return this.autoPlacement;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public AvailableCapacity availableCapacity() {
        return this.availableCapacity;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String hostId() {
        return this.hostId;
    }

    public HostProperties hostProperties() {
        return this.hostProperties;
    }

    public String hostReservationId() {
        return this.hostReservationId;
    }

    public List<HostInstance> instances() {
        return this.instances;
    }

    public AllocationState state() {
        return AllocationState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoPlacementString() == null ? 0 : this.autoPlacementString().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.availableCapacity() == null ? 0 : this.availableCapacity().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.hostId() == null ? 0 : this.hostId().hashCode());
        hashCode = 31 * hashCode + (this.hostProperties() == null ? 0 : this.hostProperties().hashCode());
        hashCode = 31 * hashCode + (this.hostReservationId() == null ? 0 : this.hostReservationId().hashCode());
        hashCode = 31 * hashCode + (this.instances() == null ? 0 : this.instances().hashCode());
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        if (other.autoPlacementString() == null ^ this.autoPlacementString() == null) {
            return false;
        }
        if (other.autoPlacementString() != null && !other.autoPlacementString().equals(this.autoPlacementString())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.availableCapacity() == null ^ this.availableCapacity() == null) {
            return false;
        }
        if (other.availableCapacity() != null && !other.availableCapacity().equals(this.availableCapacity())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.hostId() == null ^ this.hostId() == null) {
            return false;
        }
        if (other.hostId() != null && !other.hostId().equals(this.hostId())) {
            return false;
        }
        if (other.hostProperties() == null ^ this.hostProperties() == null) {
            return false;
        }
        if (other.hostProperties() != null && !other.hostProperties().equals(this.hostProperties())) {
            return false;
        }
        if (other.hostReservationId() == null ^ this.hostReservationId() == null) {
            return false;
        }
        if (other.hostReservationId() != null && !other.hostReservationId().equals(this.hostReservationId())) {
            return false;
        }
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        return other.stateString() == null || other.stateString().equals(this.stateString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.autoPlacementString() != null) {
            sb.append("AutoPlacement: ").append(this.autoPlacementString()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.availableCapacity() != null) {
            sb.append("AvailableCapacity: ").append(this.availableCapacity()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.hostId() != null) {
            sb.append("HostId: ").append(this.hostId()).append(",");
        }
        if (this.hostProperties() != null) {
            sb.append("HostProperties: ").append(this.hostProperties()).append(",");
        }
        if (this.hostReservationId() != null) {
            sb.append("HostReservationId: ").append(this.hostReservationId()).append(",");
        }
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoPlacement": {
                return Optional.of(clazz.cast(this.autoPlacementString()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "AvailableCapacity": {
                return Optional.of(clazz.cast(this.availableCapacity()));
            }
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "HostId": {
                return Optional.of(clazz.cast(this.hostId()));
            }
            case "HostProperties": {
                return Optional.of(clazz.cast(this.hostProperties()));
            }
            case "HostReservationId": {
                return Optional.of(clazz.cast(this.hostReservationId()));
            }
            case "Instances": {
                return Optional.of(clazz.cast(this.instances()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String autoPlacement;
        private String availabilityZone;
        private AvailableCapacity availableCapacity;
        private String clientToken;
        private String hostId;
        private HostProperties hostProperties;
        private String hostReservationId;
        private List<HostInstance> instances;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            this.autoPlacement(model.autoPlacement);
            this.availabilityZone(model.availabilityZone);
            this.availableCapacity(model.availableCapacity);
            this.clientToken(model.clientToken);
            this.hostId(model.hostId);
            this.hostProperties(model.hostProperties);
            this.hostReservationId(model.hostReservationId);
            this.instances(model.instances);
            this.state(model.state);
        }

        public final String getAutoPlacement() {
            return this.autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final AvailableCapacity.Builder getAvailableCapacity() {
            return this.availableCapacity != null ? this.availableCapacity.toBuilder() : null;
        }

        @Override
        public final Builder availableCapacity(AvailableCapacity availableCapacity) {
            this.availableCapacity = availableCapacity;
            return this;
        }

        public final void setAvailableCapacity(AvailableCapacity.BuilderImpl availableCapacity) {
            this.availableCapacity = availableCapacity != null ? availableCapacity.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getHostId() {
            return this.hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final HostProperties.Builder getHostProperties() {
            return this.hostProperties != null ? this.hostProperties.toBuilder() : null;
        }

        @Override
        public final Builder hostProperties(HostProperties hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        public final void setHostProperties(HostProperties.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        public final String getHostReservationId() {
            return this.hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final Collection<HostInstance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(HostInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<HostInstance> instances) {
            this.instances = HostInstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(HostInstance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<HostInstance.BuilderImpl> instances) {
            this.instances = HostInstanceListCopier.copyFromBuilder(instances);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AllocationState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public Host build() {
            return new Host(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Host> {
        public Builder autoPlacement(String var1);

        public Builder autoPlacement(AutoPlacement var1);

        public Builder availabilityZone(String var1);

        public Builder availableCapacity(AvailableCapacity var1);

        public Builder clientToken(String var1);

        public Builder hostId(String var1);

        public Builder hostProperties(HostProperties var1);

        public Builder hostReservationId(String var1);

        public Builder instances(Collection<HostInstance> var1);

        public Builder instances(HostInstance ... var1);

        public Builder state(String var1);

        public Builder state(AllocationState var1);
    }
}

