/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventInformation
implements ToCopyableBuilder<Builder, EventInformation> {
    private final String eventDescription;
    private final String eventSubType;
    private final String instanceId;

    private EventInformation(BuilderImpl builder) {
        this.eventDescription = builder.eventDescription;
        this.eventSubType = builder.eventSubType;
        this.instanceId = builder.instanceId;
    }

    public String eventDescription() {
        return this.eventDescription;
    }

    public String eventSubType() {
        return this.eventSubType;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.eventDescription() == null ? 0 : this.eventDescription().hashCode());
        hashCode = 31 * hashCode + (this.eventSubType() == null ? 0 : this.eventSubType().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventInformation)) {
            return false;
        }
        EventInformation other = (EventInformation)obj;
        if (other.eventDescription() == null ^ this.eventDescription() == null) {
            return false;
        }
        if (other.eventDescription() != null && !other.eventDescription().equals(this.eventDescription())) {
            return false;
        }
        if (other.eventSubType() == null ^ this.eventSubType() == null) {
            return false;
        }
        if (other.eventSubType() != null && !other.eventSubType().equals(this.eventSubType())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        return other.instanceId() == null || other.instanceId().equals(this.instanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.eventDescription() != null) {
            sb.append("EventDescription: ").append(this.eventDescription()).append(",");
        }
        if (this.eventSubType() != null) {
            sb.append("EventSubType: ").append(this.eventSubType()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDescription": {
                return Optional.of(clazz.cast(this.eventDescription()));
            }
            case "EventSubType": {
                return Optional.of(clazz.cast(this.eventSubType()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String eventDescription;
        private String eventSubType;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(EventInformation model) {
            this.eventDescription(model.eventDescription);
            this.eventSubType(model.eventSubType);
            this.instanceId(model.instanceId);
        }

        public final String getEventDescription() {
            return this.eventDescription;
        }

        @Override
        public final Builder eventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
            return this;
        }

        public final void setEventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
        }

        public final String getEventSubType() {
            return this.eventSubType;
        }

        @Override
        public final Builder eventSubType(String eventSubType) {
            this.eventSubType = eventSubType;
            return this;
        }

        public final void setEventSubType(String eventSubType) {
            this.eventSubType = eventSubType;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public EventInformation build() {
            return new EventInformation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventInformation> {
        public Builder eventDescription(String var1);

        public Builder eventSubType(String var1);

        public Builder instanceId(String var1);
    }
}

