/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.HostReservation;
import software.amazon.awssdk.services.ec2.model.HostReservationSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHostReservationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeHostReservationsResponse> {
    private final List<HostReservation> hostReservationSet;
    private final String nextToken;

    private DescribeHostReservationsResponse(BuilderImpl builder) {
        this.hostReservationSet = builder.hostReservationSet;
        this.nextToken = builder.nextToken;
    }

    public List<HostReservation> hostReservationSet() {
        return this.hostReservationSet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostReservationSet() == null ? 0 : this.hostReservationSet().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationsResponse)) {
            return false;
        }
        DescribeHostReservationsResponse other = (DescribeHostReservationsResponse)((Object)obj);
        if (other.hostReservationSet() == null ^ this.hostReservationSet() == null) {
            return false;
        }
        if (other.hostReservationSet() != null && !other.hostReservationSet().equals(this.hostReservationSet())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hostReservationSet() != null) {
            sb.append("HostReservationSet: ").append(this.hostReservationSet()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostReservationSet": {
                return Optional.of(clazz.cast(this.hostReservationSet()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<HostReservation> hostReservationSet;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationsResponse model) {
            this.hostReservationSet(model.hostReservationSet);
            this.nextToken(model.nextToken);
        }

        public final Collection<HostReservation.Builder> getHostReservationSet() {
            return this.hostReservationSet != null ? (Collection)this.hostReservationSet.stream().map(HostReservation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hostReservationSet(Collection<HostReservation> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copy(hostReservationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostReservationSet(HostReservation ... hostReservationSet) {
            this.hostReservationSet(Arrays.asList(hostReservationSet));
            return this;
        }

        public final void setHostReservationSet(Collection<HostReservation.BuilderImpl> hostReservationSet) {
            this.hostReservationSet = HostReservationSetCopier.copyFromBuilder(hostReservationSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeHostReservationsResponse build() {
            return new DescribeHostReservationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHostReservationsResponse> {
        public Builder hostReservationSet(Collection<HostReservation> var1);

        public Builder hostReservationSet(HostReservation ... var1);

        public Builder nextToken(String var1);
    }
}

