/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.RecurringCharge;
import software.amazon.awssdk.services.ec2.model.ReservedInstances;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.RecurringChargeUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class ReservedInstancesUnmarshaller
implements Unmarshaller<ReservedInstances, StaxUnmarshallerContext> {
    private static final ReservedInstancesUnmarshaller INSTANCE = new ReservedInstancesUnmarshaller();

    public ReservedInstances unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReservedInstances.Builder reservedInstances;
        block23: {
            reservedInstances = ReservedInstances.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<RecurringCharge> recurringCharges = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    reservedInstances.recurringCharges(recurringCharges);
                    reservedInstances.tags(tags);
                    break block23;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("availabilityZone", targetDepth)) {
                        reservedInstances.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("duration", targetDepth)) {
                        reservedInstances.duration(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("end", targetDepth)) {
                        reservedInstances.end(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("fixedPrice", targetDepth)) {
                        reservedInstances.fixedPrice(SimpleTypeStaxUnmarshallers.FloatUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceCount", targetDepth)) {
                        reservedInstances.instanceCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceType", targetDepth)) {
                        reservedInstances.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("productDescription", targetDepth)) {
                        reservedInstances.productDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("reservedInstancesId", targetDepth)) {
                        reservedInstances.reservedInstancesId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("start", targetDepth)) {
                        reservedInstances.start(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("state", targetDepth)) {
                        reservedInstances.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("usagePrice", targetDepth)) {
                        reservedInstances.usagePrice(SimpleTypeStaxUnmarshallers.FloatUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("currencyCode", targetDepth)) {
                        reservedInstances.currencyCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceTenancy", targetDepth)) {
                        reservedInstances.instanceTenancy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("offeringClass", targetDepth)) {
                        reservedInstances.offeringClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("offeringType", targetDepth)) {
                        reservedInstances.offeringType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("recurringCharges", targetDepth)) {
                        recurringCharges = new ArrayList<RecurringCharge>();
                        continue;
                    }
                    if (context.testExpression("recurringCharges/item", targetDepth)) {
                        recurringCharges.add(RecurringChargeUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("scope", targetDepth)) {
                        reservedInstances.scope(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("tagSet/item", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            reservedInstances.recurringCharges(recurringCharges);
            reservedInstances.tags(tags);
        }
        return (ReservedInstances)reservedInstances.build();
    }

    public static ReservedInstancesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

