/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyInstancePlacementRequestMarshaller
implements Marshaller<Request<ModifyInstancePlacementRequest>, ModifyInstancePlacementRequest> {
    public Request<ModifyInstancePlacementRequest> marshall(ModifyInstancePlacementRequest modifyInstancePlacementRequest) {
        if (modifyInstancePlacementRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyInstancePlacementRequest, "EC2Client");
        request.addParameter("Action", "ModifyInstancePlacement");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstancePlacementRequest.affinity() != null) {
            request.addParameter("Affinity", StringUtils.fromString((String)modifyInstancePlacementRequest.affinity()));
        }
        if (modifyInstancePlacementRequest.hostId() != null) {
            request.addParameter("HostId", StringUtils.fromString((String)modifyInstancePlacementRequest.hostId()));
        }
        if (modifyInstancePlacementRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)modifyInstancePlacementRequest.instanceId()));
        }
        if (modifyInstancePlacementRequest.tenancy() != null) {
            request.addParameter("Tenancy", StringUtils.fromString((String)modifyInstancePlacementRequest.tenancy()));
        }
        return request;
    }
}

