/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.HistoryRecord;
import software.amazon.awssdk.services.ec2.transform.EventInformationUnmarshaller;

public class HistoryRecordUnmarshaller
implements Unmarshaller<HistoryRecord, StaxUnmarshallerContext> {
    private static final HistoryRecordUnmarshaller INSTANCE = new HistoryRecordUnmarshaller();

    public HistoryRecord unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        HistoryRecord.Builder historyRecord = HistoryRecord.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("eventInformation", targetDepth)) {
                    historyRecord.eventInformation(EventInformationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("eventType", targetDepth)) {
                    historyRecord.eventType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("timestamp", targetDepth)) continue;
                historyRecord.timestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (HistoryRecord)historyRecord.build();
    }

    public static HistoryRecordUnmarshaller getInstance() {
        return INSTANCE;
    }
}

