/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreatePlacementGroupRequestMarshaller
implements Marshaller<Request<CreatePlacementGroupRequest>, CreatePlacementGroupRequest> {
    public Request<CreatePlacementGroupRequest> marshall(CreatePlacementGroupRequest createPlacementGroupRequest) {
        if (createPlacementGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPlacementGroupRequest, "EC2Client");
        request.addParameter("Action", "CreatePlacementGroup");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPlacementGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)createPlacementGroupRequest.groupName()));
        }
        if (createPlacementGroupRequest.strategy() != null) {
            request.addParameter("Strategy", StringUtils.fromString((String)createPlacementGroupRequest.strategy()));
        }
        return request;
    }
}

