/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest;
import software.amazon.awssdk.util.StringUtils;

public class AttachInternetGatewayRequestMarshaller
implements Marshaller<Request<AttachInternetGatewayRequest>, AttachInternetGatewayRequest> {
    public Request<AttachInternetGatewayRequest> marshall(AttachInternetGatewayRequest attachInternetGatewayRequest) {
        if (attachInternetGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachInternetGatewayRequest, "EC2Client");
        request.addParameter("Action", "AttachInternetGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachInternetGatewayRequest.internetGatewayId() != null) {
            request.addParameter("InternetGatewayId", StringUtils.fromString((String)attachInternetGatewayRequest.internetGatewayId()));
        }
        if (attachInternetGatewayRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)attachInternetGatewayRequest.vpcId()));
        }
        return request;
    }
}

