/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.GatewayType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VpcAttachment;
import software.amazon.awssdk.services.ec2.model.VpcAttachmentListCopier;
import software.amazon.awssdk.services.ec2.model.VpnState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpnGateway
implements ToCopyableBuilder<Builder, VpnGateway> {
    private final String availabilityZone;
    private final String state;
    private final String type;
    private final List<VpcAttachment> vpcAttachments;
    private final String vpnGatewayId;
    private final List<Tag> tags;

    private VpnGateway(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.state = builder.state;
        this.type = builder.type;
        this.vpcAttachments = builder.vpcAttachments;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.tags = builder.tags;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String state() {
        return this.state;
    }

    public String type() {
        return this.type;
    }

    public List<VpcAttachment> vpcAttachments() {
        return this.vpcAttachments;
    }

    public String vpnGatewayId() {
        return this.vpnGatewayId;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.vpcAttachments() == null ? 0 : this.vpcAttachments().hashCode());
        hashCode = 31 * hashCode + (this.vpnGatewayId() == null ? 0 : this.vpnGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnGateway)) {
            return false;
        }
        VpnGateway other = (VpnGateway)obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.vpcAttachments() == null ^ this.vpcAttachments() == null) {
            return false;
        }
        if (other.vpcAttachments() != null && !other.vpcAttachments().equals(this.vpcAttachments())) {
            return false;
        }
        if (other.vpnGatewayId() == null ^ this.vpnGatewayId() == null) {
            return false;
        }
        if (other.vpnGatewayId() != null && !other.vpnGatewayId().equals(this.vpnGatewayId())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.vpcAttachments() != null) {
            sb.append("VpcAttachments: ").append(this.vpcAttachments()).append(",");
        }
        if (this.vpnGatewayId() != null) {
            sb.append("VpnGatewayId: ").append(this.vpnGatewayId()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String state;
        private String type;
        private List<VpcAttachment> vpcAttachments;
        private String vpnGatewayId;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnGateway model) {
            this.setAvailabilityZone(model.availabilityZone);
            this.setState(model.state);
            this.setType(model.type);
            this.setVpcAttachments(model.vpcAttachments);
            this.setVpnGatewayId(model.vpnGatewayId);
            this.setTags(model.tags);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<VpcAttachment> getVpcAttachments() {
            return this.vpcAttachments;
        }

        @Override
        public final Builder vpcAttachments(Collection<VpcAttachment> vpcAttachments) {
            this.vpcAttachments = VpcAttachmentListCopier.copy(vpcAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcAttachments(VpcAttachment ... vpcAttachments) {
            this.vpcAttachments(Arrays.asList(vpcAttachments));
            return this;
        }

        public final void setVpcAttachments(Collection<VpcAttachment> vpcAttachments) {
            this.vpcAttachments = VpcAttachmentListCopier.copy(vpcAttachments);
        }

        public final String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public VpnGateway build() {
            return new VpnGateway(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpnGateway> {
        public Builder availabilityZone(String var1);

        public Builder state(String var1);

        public Builder state(VpnState var1);

        public Builder type(String var1);

        public Builder type(GatewayType var1);

        public Builder vpcAttachments(Collection<VpcAttachment> var1);

        public Builder vpcAttachments(VpcAttachment ... var1);

        public Builder vpnGatewayId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

