/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SlotDateTimeRangeRequest
implements ToCopyableBuilder<Builder, SlotDateTimeRangeRequest> {
    private final Instant earliestTime;
    private final Instant latestTime;

    private SlotDateTimeRangeRequest(BuilderImpl builder) {
        this.earliestTime = builder.earliestTime;
        this.latestTime = builder.latestTime;
    }

    public Instant earliestTime() {
        return this.earliestTime;
    }

    public Instant latestTime() {
        return this.latestTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.earliestTime() == null ? 0 : this.earliestTime().hashCode());
        hashCode = 31 * hashCode + (this.latestTime() == null ? 0 : this.latestTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotDateTimeRangeRequest)) {
            return false;
        }
        SlotDateTimeRangeRequest other = (SlotDateTimeRangeRequest)obj;
        if (other.earliestTime() == null ^ this.earliestTime() == null) {
            return false;
        }
        if (other.earliestTime() != null && !other.earliestTime().equals(this.earliestTime())) {
            return false;
        }
        if (other.latestTime() == null ^ this.latestTime() == null) {
            return false;
        }
        return other.latestTime() == null || other.latestTime().equals(this.latestTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.earliestTime() != null) {
            sb.append("EarliestTime: ").append(this.earliestTime()).append(",");
        }
        if (this.latestTime() != null) {
            sb.append("LatestTime: ").append(this.latestTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant earliestTime;
        private Instant latestTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotDateTimeRangeRequest model) {
            this.setEarliestTime(model.earliestTime);
            this.setLatestTime(model.latestTime);
        }

        public final Instant getEarliestTime() {
            return this.earliestTime;
        }

        @Override
        public final Builder earliestTime(Instant earliestTime) {
            this.earliestTime = earliestTime;
            return this;
        }

        public final void setEarliestTime(Instant earliestTime) {
            this.earliestTime = earliestTime;
        }

        public final Instant getLatestTime() {
            return this.latestTime;
        }

        @Override
        public final Builder latestTime(Instant latestTime) {
            this.latestTime = latestTime;
            return this;
        }

        public final void setLatestTime(Instant latestTime) {
            this.latestTime = latestTime;
        }

        public SlotDateTimeRangeRequest build() {
            return new SlotDateTimeRangeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SlotDateTimeRangeRequest> {
        public Builder earliestTime(Instant var1);

        public Builder latestTime(Instant var1);
    }
}

