/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservationValue
implements ToCopyableBuilder<Builder, ReservationValue> {
    private final String hourlyPrice;
    private final String remainingTotalValue;
    private final String remainingUpfrontValue;

    private ReservationValue(BuilderImpl builder) {
        this.hourlyPrice = builder.hourlyPrice;
        this.remainingTotalValue = builder.remainingTotalValue;
        this.remainingUpfrontValue = builder.remainingUpfrontValue;
    }

    public String hourlyPrice() {
        return this.hourlyPrice;
    }

    public String remainingTotalValue() {
        return this.remainingTotalValue;
    }

    public String remainingUpfrontValue() {
        return this.remainingUpfrontValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hourlyPrice() == null ? 0 : this.hourlyPrice().hashCode());
        hashCode = 31 * hashCode + (this.remainingTotalValue() == null ? 0 : this.remainingTotalValue().hashCode());
        hashCode = 31 * hashCode + (this.remainingUpfrontValue() == null ? 0 : this.remainingUpfrontValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationValue)) {
            return false;
        }
        ReservationValue other = (ReservationValue)obj;
        if (other.hourlyPrice() == null ^ this.hourlyPrice() == null) {
            return false;
        }
        if (other.hourlyPrice() != null && !other.hourlyPrice().equals(this.hourlyPrice())) {
            return false;
        }
        if (other.remainingTotalValue() == null ^ this.remainingTotalValue() == null) {
            return false;
        }
        if (other.remainingTotalValue() != null && !other.remainingTotalValue().equals(this.remainingTotalValue())) {
            return false;
        }
        if (other.remainingUpfrontValue() == null ^ this.remainingUpfrontValue() == null) {
            return false;
        }
        return other.remainingUpfrontValue() == null || other.remainingUpfrontValue().equals(this.remainingUpfrontValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hourlyPrice() != null) {
            sb.append("HourlyPrice: ").append(this.hourlyPrice()).append(",");
        }
        if (this.remainingTotalValue() != null) {
            sb.append("RemainingTotalValue: ").append(this.remainingTotalValue()).append(",");
        }
        if (this.remainingUpfrontValue() != null) {
            sb.append("RemainingUpfrontValue: ").append(this.remainingUpfrontValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String hourlyPrice;
        private String remainingTotalValue;
        private String remainingUpfrontValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationValue model) {
            this.setHourlyPrice(model.hourlyPrice);
            this.setRemainingTotalValue(model.remainingTotalValue);
            this.setRemainingUpfrontValue(model.remainingUpfrontValue);
        }

        public final String getHourlyPrice() {
            return this.hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final String getRemainingTotalValue() {
            return this.remainingTotalValue;
        }

        @Override
        public final Builder remainingTotalValue(String remainingTotalValue) {
            this.remainingTotalValue = remainingTotalValue;
            return this;
        }

        public final void setRemainingTotalValue(String remainingTotalValue) {
            this.remainingTotalValue = remainingTotalValue;
        }

        public final String getRemainingUpfrontValue() {
            return this.remainingUpfrontValue;
        }

        @Override
        public final Builder remainingUpfrontValue(String remainingUpfrontValue) {
            this.remainingUpfrontValue = remainingUpfrontValue;
            return this;
        }

        public final void setRemainingUpfrontValue(String remainingUpfrontValue) {
            this.remainingUpfrontValue = remainingUpfrontValue;
        }

        public ReservationValue build() {
            return new ReservationValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservationValue> {
        public Builder hourlyPrice(String var1);

        public Builder remainingTotalValue(String var1);

        public Builder remainingUpfrontValue(String var1);
    }
}

