/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchPermission;
import software.amazon.awssdk.services.ec2.model.LaunchPermissionListCopier;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageAttribute
implements ToCopyableBuilder<Builder, ImageAttribute> {
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String imageId;
    private final List<LaunchPermission> launchPermissions;
    private final List<ProductCode> productCodes;
    private final String description;
    private final String kernelId;
    private final String ramdiskId;
    private final String sriovNetSupport;

    private ImageAttribute(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.imageId = builder.imageId;
        this.launchPermissions = builder.launchPermissions;
        this.productCodes = builder.productCodes;
        this.description = builder.description;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.sriovNetSupport = builder.sriovNetSupport;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String imageId() {
        return this.imageId;
    }

    public List<LaunchPermission> launchPermissions() {
        return this.launchPermissions;
    }

    public List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public String description() {
        return this.description;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.launchPermissions() == null ? 0 : this.launchPermissions().hashCode());
        hashCode = 31 * hashCode + (this.productCodes() == null ? 0 : this.productCodes().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.kernelId() == null ? 0 : this.kernelId().hashCode());
        hashCode = 31 * hashCode + (this.ramdiskId() == null ? 0 : this.ramdiskId().hashCode());
        hashCode = 31 * hashCode + (this.sriovNetSupport() == null ? 0 : this.sriovNetSupport().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageAttribute)) {
            return false;
        }
        ImageAttribute other = (ImageAttribute)obj;
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.launchPermissions() == null ^ this.launchPermissions() == null) {
            return false;
        }
        if (other.launchPermissions() != null && !other.launchPermissions().equals(this.launchPermissions())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.sriovNetSupport() == null ^ this.sriovNetSupport() == null) {
            return false;
        }
        return other.sriovNetSupport() == null || other.sriovNetSupport().equals(this.sriovNetSupport());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.launchPermissions() != null) {
            sb.append("LaunchPermissions: ").append(this.launchPermissions()).append(",");
        }
        if (this.productCodes() != null) {
            sb.append("ProductCodes: ").append(this.productCodes()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.kernelId() != null) {
            sb.append("KernelId: ").append(this.kernelId()).append(",");
        }
        if (this.ramdiskId() != null) {
            sb.append("RamdiskId: ").append(this.ramdiskId()).append(",");
        }
        if (this.sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(this.sriovNetSupport()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings;
        private String imageId;
        private List<LaunchPermission> launchPermissions;
        private List<ProductCode> productCodes;
        private String description;
        private String kernelId;
        private String ramdiskId;
        private String sriovNetSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageAttribute model) {
            this.setBlockDeviceMappings(model.blockDeviceMappings);
            this.setImageId(model.imageId);
            this.setLaunchPermissions(model.launchPermissions);
            this.setProductCodes(model.productCodes);
            this.setDescription(model.description);
            this.setKernelId(model.kernelId);
            this.setRamdiskId(model.ramdiskId);
            this.setSriovNetSupport(model.sriovNetSupport);
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Collection<LaunchPermission> getLaunchPermissions() {
            return this.launchPermissions;
        }

        @Override
        public final Builder launchPermissions(Collection<LaunchPermission> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copy(launchPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(LaunchPermission ... launchPermissions) {
            this.launchPermissions(Arrays.asList(launchPermissions));
            return this;
        }

        public final void setLaunchPermissions(Collection<LaunchPermission> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copy(launchPermissions);
        }

        public final Collection<ProductCode> getProductCodes() {
            return this.productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public ImageAttribute build() {
            return new ImageAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageAttribute> {
        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder imageId(String var1);

        public Builder launchPermissions(Collection<LaunchPermission> var1);

        public Builder launchPermissions(LaunchPermission ... var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder description(String var1);

        public Builder kernelId(String var1);

        public Builder ramdiskId(String var1);

        public Builder sriovNetSupport(String var1);
    }
}

