/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DetachNetworkInterfaceRequest;
import software.amazon.awssdk.util.StringUtils;

public class DetachNetworkInterfaceRequestMarshaller
implements Marshaller<Request<DetachNetworkInterfaceRequest>, DetachNetworkInterfaceRequest> {
    public Request<DetachNetworkInterfaceRequest> marshall(DetachNetworkInterfaceRequest detachNetworkInterfaceRequest) {
        if (detachNetworkInterfaceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)detachNetworkInterfaceRequest, "EC2Client");
        request.addParameter("Action", "DetachNetworkInterface");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachNetworkInterfaceRequest.attachmentId() != null) {
            request.addParameter("AttachmentId", StringUtils.fromString((String)detachNetworkInterfaceRequest.attachmentId()));
        }
        if (detachNetworkInterfaceRequest.force() != null) {
            request.addParameter("Force", StringUtils.fromBoolean((Boolean)detachNetworkInterfaceRequest.force()));
        }
        return request;
    }
}

