/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMappingRequestListCopier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.ShutdownBehavior;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RunInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RunInstancesRequest> {
    private final List<BlockDeviceMapping> blockDeviceMappings;
    private final String imageId;
    private final String instanceType;
    private final Integer ipv6AddressCount;
    private final List<InstanceIpv6Address> ipv6Addresses;
    private final String kernelId;
    private final String keyName;
    private final Integer maxCount;
    private final Integer minCount;
    private final Boolean monitoring;
    private final Placement placement;
    private final String ramdiskId;
    private final List<String> securityGroupIds;
    private final List<String> securityGroups;
    private final String subnetId;
    private final String userData;
    private final String additionalInfo;
    private final String clientToken;
    private final Boolean disableApiTermination;
    private final Boolean ebsOptimized;
    private final IamInstanceProfileSpecification iamInstanceProfile;
    private final String instanceInitiatedShutdownBehavior;
    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private final String privateIpAddress;
    private final List<TagSpecification> tagSpecifications;

    private RunInstancesRequest(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.maxCount = builder.maxCount;
        this.minCount = builder.minCount;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
        this.additionalInfo = builder.additionalInfo;
        this.clientToken = builder.clientToken;
        this.disableApiTermination = builder.disableApiTermination;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.networkInterfaces = builder.networkInterfaces;
        this.privateIpAddress = builder.privateIpAddress;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public List<BlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public String imageId() {
        return this.imageId;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public List<InstanceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String kernelId() {
        return this.kernelId;
    }

    public String keyName() {
        return this.keyName;
    }

    public Integer maxCount() {
        return this.maxCount;
    }

    public Integer minCount() {
        return this.minCount;
    }

    public Boolean monitoring() {
        return this.monitoring;
    }

    public Placement placement() {
        return this.placement;
    }

    public String ramdiskId() {
        return this.ramdiskId;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String userData() {
        return this.userData;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public IamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public String instanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.blockDeviceMappings() == null ? 0 : this.blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.ipv6AddressCount() == null ? 0 : this.ipv6AddressCount().hashCode());
        hashCode = 31 * hashCode + (this.ipv6Addresses() == null ? 0 : this.ipv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.kernelId() == null ? 0 : this.kernelId().hashCode());
        hashCode = 31 * hashCode + (this.keyName() == null ? 0 : this.keyName().hashCode());
        hashCode = 31 * hashCode + (this.maxCount() == null ? 0 : this.maxCount().hashCode());
        hashCode = 31 * hashCode + (this.minCount() == null ? 0 : this.minCount().hashCode());
        hashCode = 31 * hashCode + (this.monitoring() == null ? 0 : this.monitoring().hashCode());
        hashCode = 31 * hashCode + (this.placement() == null ? 0 : this.placement().hashCode());
        hashCode = 31 * hashCode + (this.ramdiskId() == null ? 0 : this.ramdiskId().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.securityGroups() == null ? 0 : this.securityGroups().hashCode());
        hashCode = 31 * hashCode + (this.subnetId() == null ? 0 : this.subnetId().hashCode());
        hashCode = 31 * hashCode + (this.userData() == null ? 0 : this.userData().hashCode());
        hashCode = 31 * hashCode + (this.additionalInfo() == null ? 0 : this.additionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.disableApiTermination() == null ? 0 : this.disableApiTermination().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.iamInstanceProfile() == null ? 0 : this.iamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.instanceInitiatedShutdownBehavior() == null ? 0 : this.instanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaces() == null ? 0 : this.networkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.tagSpecifications() == null ? 0 : this.tagSpecifications().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunInstancesRequest)) {
            return false;
        }
        RunInstancesRequest other = (RunInstancesRequest)((Object)obj);
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.ipv6AddressCount() == null ^ this.ipv6AddressCount() == null) {
            return false;
        }
        if (other.ipv6AddressCount() != null && !other.ipv6AddressCount().equals(this.ipv6AddressCount())) {
            return false;
        }
        if (other.ipv6Addresses() == null ^ this.ipv6Addresses() == null) {
            return false;
        }
        if (other.ipv6Addresses() != null && !other.ipv6Addresses().equals(this.ipv6Addresses())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.keyName() == null ^ this.keyName() == null) {
            return false;
        }
        if (other.keyName() != null && !other.keyName().equals(this.keyName())) {
            return false;
        }
        if (other.maxCount() == null ^ this.maxCount() == null) {
            return false;
        }
        if (other.maxCount() != null && !other.maxCount().equals(this.maxCount())) {
            return false;
        }
        if (other.minCount() == null ^ this.minCount() == null) {
            return false;
        }
        if (other.minCount() != null && !other.minCount().equals(this.minCount())) {
            return false;
        }
        if (other.monitoring() == null ^ this.monitoring() == null) {
            return false;
        }
        if (other.monitoring() != null && !other.monitoring().equals(this.monitoring())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        if (other.additionalInfo() == null ^ this.additionalInfo() == null) {
            return false;
        }
        if (other.additionalInfo() != null && !other.additionalInfo().equals(this.additionalInfo())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.disableApiTermination() == null ^ this.disableApiTermination() == null) {
            return false;
        }
        if (other.disableApiTermination() != null && !other.disableApiTermination().equals(this.disableApiTermination())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.iamInstanceProfile() == null ^ this.iamInstanceProfile() == null) {
            return false;
        }
        if (other.iamInstanceProfile() != null && !other.iamInstanceProfile().equals(this.iamInstanceProfile())) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() == null ^ this.instanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() != null && !other.instanceInitiatedShutdownBehavior().equals(this.instanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.networkInterfaces() == null ^ this.networkInterfaces() == null) {
            return false;
        }
        if (other.networkInterfaces() != null && !other.networkInterfaces().equals(this.networkInterfaces())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.tagSpecifications() == null ^ this.tagSpecifications() == null) {
            return false;
        }
        return other.tagSpecifications() == null || other.tagSpecifications().equals(this.tagSpecifications());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.blockDeviceMappings()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.ipv6AddressCount() != null) {
            sb.append("Ipv6AddressCount: ").append(this.ipv6AddressCount()).append(",");
        }
        if (this.ipv6Addresses() != null) {
            sb.append("Ipv6Addresses: ").append(this.ipv6Addresses()).append(",");
        }
        if (this.kernelId() != null) {
            sb.append("KernelId: ").append(this.kernelId()).append(",");
        }
        if (this.keyName() != null) {
            sb.append("KeyName: ").append(this.keyName()).append(",");
        }
        if (this.maxCount() != null) {
            sb.append("MaxCount: ").append(this.maxCount()).append(",");
        }
        if (this.minCount() != null) {
            sb.append("MinCount: ").append(this.minCount()).append(",");
        }
        if (this.monitoring() != null) {
            sb.append("Monitoring: ").append(this.monitoring()).append(",");
        }
        if (this.placement() != null) {
            sb.append("Placement: ").append(this.placement()).append(",");
        }
        if (this.ramdiskId() != null) {
            sb.append("RamdiskId: ").append(this.ramdiskId()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.securityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.securityGroups()).append(",");
        }
        if (this.subnetId() != null) {
            sb.append("SubnetId: ").append(this.subnetId()).append(",");
        }
        if (this.userData() != null) {
            sb.append("UserData: ").append(this.userData()).append(",");
        }
        if (this.additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.additionalInfo()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.disableApiTermination() != null) {
            sb.append("DisableApiTermination: ").append(this.disableApiTermination()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.iamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.iamInstanceProfile()).append(",");
        }
        if (this.instanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(this.instanceInitiatedShutdownBehavior()).append(",");
        }
        if (this.networkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.networkInterfaces()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        if (this.tagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.tagSpecifications()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings;
        private String imageId;
        private String instanceType;
        private Integer ipv6AddressCount;
        private List<InstanceIpv6Address> ipv6Addresses;
        private String kernelId;
        private String keyName;
        private Integer maxCount;
        private Integer minCount;
        private Boolean monitoring;
        private Placement placement;
        private String ramdiskId;
        private List<String> securityGroupIds;
        private List<String> securityGroups;
        private String subnetId;
        private String userData;
        private String additionalInfo;
        private String clientToken;
        private Boolean disableApiTermination;
        private Boolean ebsOptimized;
        private IamInstanceProfileSpecification iamInstanceProfile;
        private String instanceInitiatedShutdownBehavior;
        private List<InstanceNetworkInterfaceSpecification> networkInterfaces;
        private String privateIpAddress;
        private List<TagSpecification> tagSpecifications;

        private BuilderImpl() {
        }

        private BuilderImpl(RunInstancesRequest model) {
            this.setBlockDeviceMappings(model.blockDeviceMappings);
            this.setImageId(model.imageId);
            this.setInstanceType(model.instanceType);
            this.setIpv6AddressCount(model.ipv6AddressCount);
            this.setIpv6Addresses(model.ipv6Addresses);
            this.setKernelId(model.kernelId);
            this.setKeyName(model.keyName);
            this.setMaxCount(model.maxCount);
            this.setMinCount(model.minCount);
            this.setMonitoring(model.monitoring);
            this.setPlacement(model.placement);
            this.setRamdiskId(model.ramdiskId);
            this.setSecurityGroupIds(model.securityGroupIds);
            this.setSecurityGroups(model.securityGroups);
            this.setSubnetId(model.subnetId);
            this.setUserData(model.userData);
            this.setAdditionalInfo(model.additionalInfo);
            this.setClientToken(model.clientToken);
            this.setDisableApiTermination(model.disableApiTermination);
            this.setEbsOptimized(model.ebsOptimized);
            this.setIamInstanceProfile(model.iamInstanceProfile);
            this.setInstanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.setNetworkInterfaces(model.networkInterfaces);
            this.setPrivateIpAddress(model.privateIpAddress);
            this.setTagSpecifications(model.tagSpecifications);
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final Collection<InstanceIpv6Address> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Integer getMaxCount() {
            return this.maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        public final Integer getMinCount() {
            return this.minCount;
        }

        @Override
        public final Builder minCount(Integer minCount) {
            this.minCount = minCount;
            return this;
        }

        public final void setMinCount(Integer minCount) {
            this.minCount = minCount;
        }

        public final Boolean getMonitoring() {
            return this.monitoring;
        }

        @Override
        public final Builder monitoring(Boolean monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Boolean monitoring) {
            this.monitoring = monitoring;
        }

        public final Placement getPlacement() {
            return this.placement;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement placement) {
            this.placement = placement;
        }

        public final String getRamdiskId() {
            return this.ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final IamInstanceProfileSpecification getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final Collection<InstanceNetworkInterfaceSpecification> getNetworkInterfaces() {
            return this.networkInterfaces;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<TagSpecification> getTagSpecifications() {
            return this.tagSpecifications;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
        }

        public RunInstancesRequest build() {
            return new RunInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RunInstancesRequest> {
        public Builder blockDeviceMappings(Collection<BlockDeviceMapping> var1);

        public Builder blockDeviceMappings(BlockDeviceMapping ... var1);

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder ipv6AddressCount(Integer var1);

        public Builder ipv6Addresses(Collection<InstanceIpv6Address> var1);

        public Builder ipv6Addresses(InstanceIpv6Address ... var1);

        public Builder kernelId(String var1);

        public Builder keyName(String var1);

        public Builder maxCount(Integer var1);

        public Builder minCount(Integer var1);

        public Builder monitoring(Boolean var1);

        public Builder placement(Placement var1);

        public Builder ramdiskId(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder subnetId(String var1);

        public Builder userData(String var1);

        public Builder additionalInfo(String var1);

        public Builder clientToken(String var1);

        public Builder disableApiTermination(Boolean var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(IamInstanceProfileSpecification var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceInitiatedShutdownBehavior(ShutdownBehavior var1);

        public Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(InstanceNetworkInterfaceSpecification ... var1);

        public Builder privateIpAddress(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);
    }
}

