/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum ResourceType {
    CustomerGateway("customer-gateway"),
    DhcpOptions("dhcp-options"),
    Image("image"),
    Instance("instance"),
    InternetGateway("internet-gateway"),
    NetworkAcl("network-acl"),
    NetworkInterface("network-interface"),
    ReservedInstances("reserved-instances"),
    RouteTable("route-table"),
    Snapshot("snapshot"),
    SpotInstancesRequest("spot-instances-request"),
    Subnet("subnet"),
    SecurityGroup("security-group"),
    Volume("volume"),
    Vpc("vpc"),
    VpnConnection("vpn-connection"),
    VpnGateway("vpn-gateway");

    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static ResourceType fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(ResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

