/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Subnet;
import software.amazon.awssdk.services.ec2.model.SubnetIpv6CidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.SubnetIpv6CidrBlockAssociationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class SubnetUnmarshaller
implements Unmarshaller<Subnet, StaxUnmarshallerContext> {
    private static SubnetUnmarshaller INSTANCE;

    public Subnet unmarshall(StaxUnmarshallerContext context) throws Exception {
        Subnet.Builder subnet;
        block16: {
            subnet = Subnet.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    subnet.ipv6CidrBlockAssociationSet(ipv6CidrBlockAssociationSet);
                    subnet.tags(tags);
                    break block16;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("availabilityZone", targetDepth)) {
                        subnet.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("availableIpAddressCount", targetDepth)) {
                        subnet.availableIpAddressCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("cidrBlock", targetDepth)) {
                        subnet.cidrBlock(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("defaultForAz", targetDepth)) {
                        subnet.defaultForAz(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("mapPublicIpOnLaunch", targetDepth)) {
                        subnet.mapPublicIpOnLaunch(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("state", targetDepth)) {
                        subnet.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("subnetId", targetDepth)) {
                        subnet.subnetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("vpcId", targetDepth)) {
                        subnet.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("assignIpv6AddressOnCreation", targetDepth)) {
                        subnet.assignIpv6AddressOnCreation(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ipv6CidrBlockAssociationSet", targetDepth)) {
                        ipv6CidrBlockAssociationSet = new ArrayList<SubnetIpv6CidrBlockAssociation>();
                        continue;
                    }
                    if (context.testExpression("ipv6CidrBlockAssociationSet/item", targetDepth)) {
                        ipv6CidrBlockAssociationSet.add(SubnetIpv6CidrBlockAssociationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("tagSet/item", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            subnet.ipv6CidrBlockAssociationSet(ipv6CidrBlockAssociationSet);
            subnet.tags(tags);
        }
        return (Subnet)subnet.build();
    }

    public static SubnetUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SubnetUnmarshaller();
        }
        return INSTANCE;
    }
}

