/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.PeeringConnectionOptions;

public class PeeringConnectionOptionsUnmarshaller
implements Unmarshaller<PeeringConnectionOptions, StaxUnmarshallerContext> {
    private static PeeringConnectionOptionsUnmarshaller INSTANCE;

    public PeeringConnectionOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PeeringConnectionOptions.Builder peeringConnectionOptions = PeeringConnectionOptions.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("allowDnsResolutionFromRemoteVpc", targetDepth)) {
                    peeringConnectionOptions.allowDnsResolutionFromRemoteVpc(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("allowEgressFromLocalClassicLinkToRemoteVpc", targetDepth)) {
                    peeringConnectionOptions.allowEgressFromLocalClassicLinkToRemoteVpc(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("allowEgressFromLocalVpcToRemoteClassicLink", targetDepth)) continue;
                peeringConnectionOptions.allowEgressFromLocalVpcToRemoteClassicLink(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PeeringConnectionOptions)peeringConnectionOptions.build();
    }

    public static PeeringConnectionOptionsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PeeringConnectionOptionsUnmarshaller();
        }
        return INSTANCE;
    }
}

