/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.BlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ProductCodeUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.StateReasonUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class ImageUnmarshaller
implements Unmarshaller<Image, StaxUnmarshallerContext> {
    private static ImageUnmarshaller INSTANCE;

    public Image unmarshall(StaxUnmarshallerContext context) throws Exception {
        Image.Builder image;
        block30: {
            image = Image.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<ProductCode> productCodes = null;
            ArrayList<BlockDeviceMapping> blockDeviceMappings = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    image.productCodes(productCodes);
                    image.blockDeviceMappings(blockDeviceMappings);
                    image.tags(tags);
                    break block30;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("architecture", targetDepth)) {
                        image.architecture(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("creationDate", targetDepth)) {
                        image.creationDate(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("imageId", targetDepth)) {
                        image.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("imageLocation", targetDepth)) {
                        image.imageLocation(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("imageType", targetDepth)) {
                        image.imageType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("kernelId", targetDepth)) {
                        image.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("imageOwnerId", targetDepth)) {
                        image.ownerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("platform", targetDepth)) {
                        image.platform(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("productCodes", targetDepth)) {
                        productCodes = new ArrayList<ProductCode>();
                        continue;
                    }
                    if (context.testExpression("productCodes/item", targetDepth)) {
                        productCodes.add(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ramdiskId", targetDepth)) {
                        image.ramdiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("imageState", targetDepth)) {
                        image.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("blockDeviceMapping", targetDepth)) {
                        blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
                        continue;
                    }
                    if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                        blockDeviceMappings.add(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("description", targetDepth)) {
                        image.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("enaSupport", targetDepth)) {
                        image.enaSupport(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("hypervisor", targetDepth)) {
                        image.hypervisor(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("imageOwnerAlias", targetDepth)) {
                        image.imageOwnerAlias(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("name", targetDepth)) {
                        image.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("rootDeviceName", targetDepth)) {
                        image.rootDeviceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("rootDeviceType", targetDepth)) {
                        image.rootDeviceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("sriovNetSupport", targetDepth)) {
                        image.sriovNetSupport(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("stateReason", targetDepth)) {
                        image.stateReason(StateReasonUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (context.testExpression("tagSet/item", targetDepth)) {
                        tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("virtualizationType", targetDepth)) {
                        image.virtualizationType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("isPublic", targetDepth)) continue;
                    image.publicLaunchPermissions(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            image.productCodes(productCodes);
            image.blockDeviceMappings(blockDeviceMappings);
            image.tags(tags);
        }
        return (Image)image.build();
    }

    public static ImageUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ImageUnmarshaller();
        }
        return INSTANCE;
    }
}

